/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.fido.u2f.protocol;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import org.gluu.oxauth.model.fido.u2f.exception.BadInputException;
import org.gluu.oxauth.model.fido.u2f.protocol.ClientData;
import org.jboss.resteasy.annotations.providers.jaxb.IgnoreMediaTypes;

@IgnoreMediaTypes(value={"application/*+json"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class AuthenticateResponse
implements Serializable {
    private static final long serialVersionUID = -4854326288654670000L;
    @JsonProperty
    private final String clientData;
    @JsonIgnore
    private transient ClientData clientDataRef;
    @JsonProperty
    private final String signatureData;
    @JsonProperty
    private final String keyHandle;
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final String deviceData;

    public String getDeviceData() {
        return this.deviceData;
    }

    public AuthenticateResponse(@JsonProperty(value="clientData") String clientData, @JsonProperty(value="signatureData") String signatureData, @JsonProperty(value="keyHandle") String keyHandle, @JsonProperty(value="deviceData") String deviceData) throws BadInputException {
        this.clientData = clientData;
        this.signatureData = signatureData;
        this.keyHandle = keyHandle;
        this.clientDataRef = new ClientData(clientData);
        this.deviceData = deviceData;
    }

    public ClientData getClientData() {
        return this.clientDataRef;
    }

    public String getClientDataRaw() {
        return this.clientData;
    }

    public String getSignatureData() {
        return this.signatureData;
    }

    public String getKeyHandle() {
        return this.keyHandle;
    }

    @JsonIgnore
    public String getRequestId() {
        return this.getClientData().getChallenge();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AuthenticateResponse [clientData=").append(this.clientData).append(", signatureData=").append(this.signatureData).append(", keyHandle=").append(this.keyHandle).append(",deviceData=").append("]");
        return builder.toString();
    }
}

