/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.error;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import org.gluu.oxauth.model.common.HasParamName;
import org.gluu.persist.annotation.AttributeEnum;

public enum ErrorHandlingMethod implements HasParamName,
AttributeEnum
{
    INTERNAL("internal"),
    REMOTE("remote");

    private final String value;
    private static Map<String, ErrorHandlingMethod> mapByValues;

    private ErrorHandlingMethod() {
        this.value = null;
    }

    private ErrorHandlingMethod(String value) {
        this.value = value;
    }

    @Override
    public String getParamName() {
        return this.value;
    }

    public String getValue() {
        return this.value;
    }

    @JsonCreator
    public static ErrorHandlingMethod fromString(String param) {
        if (param != null) {
            for (ErrorHandlingMethod hm : ErrorHandlingMethod.values()) {
                if (!param.equals(hm.value)) continue;
                return hm;
            }
        }
        return null;
    }

    public static String[] toStringArray(ErrorHandlingMethod[] grantTypes) {
        if (grantTypes == null) {
            return null;
        }
        String[] resultGrantTypes = new String[grantTypes.length];
        for (int i = 0; i < grantTypes.length; ++i) {
            resultGrantTypes[i] = grantTypes[i].getValue();
        }
        return resultGrantTypes;
    }

    public static ErrorHandlingMethod getByValue(String value) {
        return mapByValues.get(value);
    }

    public Enum<? extends AttributeEnum> resolveByValue(String value) {
        return ErrorHandlingMethod.getByValue(value);
    }

    @JsonValue
    public String toString() {
        return this.value;
    }

    static {
        mapByValues = new HashMap<String, ErrorHandlingMethod>();
        for (ErrorHandlingMethod enumType : ErrorHandlingMethod.values()) {
            mapByValues.put(enumType.getValue(), enumType);
        }
    }
}

