/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.crypto.signature;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum ECEllipticCurve {
    P_256("P-256", "secp256r1", "1.2.840.10045.3.1.7"),
    P_384("P-384", "secp384r1", "1.3.132.0.34"),
    P_521("P-521", "secp521r1", "1.3.132.0.35");

    private final String name;
    private final String alias;
    private final String oid;

    private ECEllipticCurve(String name, String alias, String oid) {
        this.name = name;
        this.alias = alias;
        this.oid = oid;
    }

    public String getName() {
        return this.name;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getOid() {
        return this.oid;
    }

    @JsonCreator
    public static ECEllipticCurve fromString(String param) {
        if (param != null) {
            for (ECEllipticCurve ec : ECEllipticCurve.values()) {
                if (!param.equals(ec.name) && !param.equalsIgnoreCase(ec.name())) continue;
                return ec;
            }
        }
        return null;
    }

    @JsonValue
    public String toString() {
        return this.name;
    }
}

