/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.crypto.signature;

import java.math.BigInteger;
import org.gluu.oxauth.model.crypto.PublicKey;
import org.gluu.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.gluu.oxauth.model.util.Base64Util;
import org.json.JSONException;
import org.json.JSONObject;

public class ECDSAPublicKey
extends PublicKey {
    private static final String ECDSA_ALGORITHM = "EC";
    private static final String USE = "sig";
    private SignatureAlgorithm signatureAlgorithm;
    private BigInteger x;
    private BigInteger y;

    public ECDSAPublicKey(SignatureAlgorithm signatureAlgorithm, BigInteger x, BigInteger y) {
        this.signatureAlgorithm = signatureAlgorithm;
        this.x = x;
        this.y = y;
    }

    public ECDSAPublicKey(SignatureAlgorithm signatureAlgorithm, String x, String y) {
        this(signatureAlgorithm, new BigInteger(1, Base64Util.base64urldecode(x)), new BigInteger(1, Base64Util.base64urldecode(y)));
    }

    @Override
    public SignatureAlgorithm getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    @Override
    public void setSignatureAlgorithm(SignatureAlgorithm signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
    }

    public BigInteger getX() {
        return this.x;
    }

    public void setX(BigInteger x) {
        this.x = x;
    }

    public BigInteger getY() {
        return this.y;
    }

    public void setY(BigInteger y) {
        this.y = y;
    }

    @Override
    public JSONObject toJSONObject() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("n", JSONObject.NULL);
        jsonObject.put("e", JSONObject.NULL);
        jsonObject.put("x", (Object)Base64Util.base64urlencodeUnsignedBigInt(this.x));
        jsonObject.put("y", (Object)Base64Util.base64urlencodeUnsignedBigInt(this.y));
        return jsonObject;
    }

    public String toString() {
        try {
            return this.toJSONObject().toString(4);
        }
        catch (JSONException e) {
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }
}

