/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.crypto.signature;

import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.commons.lang.StringUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.gluu.oxauth.model.crypto.Certificate;
import org.gluu.oxauth.model.crypto.KeyFactory;
import org.gluu.oxauth.model.crypto.signature.ECDSAPrivateKey;
import org.gluu.oxauth.model.crypto.signature.ECDSAPublicKey;
import org.gluu.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.gluu.util.security.SecurityProviderUtility;

public class ECDSAKeyFactory
extends KeyFactory<ECDSAPrivateKey, ECDSAPublicKey> {
    private SignatureAlgorithm signatureAlgorithm;
    private KeyPair keyPair;
    private ECDSAPrivateKey ecdsaPrivateKey;
    private ECDSAPublicKey ecdsaPublicKey;
    private Certificate certificate;

    public ECDSAKeyFactory(SignatureAlgorithm signatureAlgorithm, String dnName) throws NoSuchAlgorithmException, InvalidParameterSpecException, InvalidAlgorithmParameterException, OperatorCreationException, CertificateException, CertIOException {
        if (signatureAlgorithm == null) {
            throw new InvalidParameterException("The signature algorithm cannot be null");
        }
        this.signatureAlgorithm = signatureAlgorithm;
        AlgorithmParameters parameters = AlgorithmParameters.getInstance("EC", SecurityProviderUtility.getBCProvider());
        parameters.init(new ECGenParameterSpec(signatureAlgorithm.getCurve().getName()));
        ECParameterSpec ecParameters = parameters.getParameterSpec(ECParameterSpec.class);
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("EC", SecurityProviderUtility.getBCProvider());
        keyGen.initialize(ecParameters, new SecureRandom());
        this.keyPair = keyGen.generateKeyPair();
        ECPrivateKey privateKeySpec = (ECPrivateKey)this.keyPair.getPrivate();
        ECPublicKey publicKeySpec = (ECPublicKey)this.keyPair.getPublic();
        BigInteger x = publicKeySpec.getW().getAffineX();
        BigInteger y = publicKeySpec.getW().getAffineY();
        BigInteger s = privateKeySpec.getS();
        this.ecdsaPrivateKey = new ECDSAPrivateKey(s);
        this.ecdsaPublicKey = new ECDSAPublicKey(signatureAlgorithm, x, y);
        if (StringUtils.isNotBlank((String)dnName)) {
            GregorianCalendar startDate = new GregorianCalendar();
            GregorianCalendar expiryDate = new GregorianCalendar();
            expiryDate.add(1, 1);
            this.certificate = this.generateV3Certificate(startDate.getTime(), expiryDate.getTime(), dnName);
        }
    }

    public Certificate generateV3Certificate(Date startDate, Date expirationDate, String dnName) throws OperatorCreationException, CertificateException, CertIOException {
        BigInteger serialNumber = new BigInteger(1024, new SecureRandom());
        X500Name name = new X500Name(dnName);
        JcaX509v3CertificateBuilder certGen = new JcaX509v3CertificateBuilder(name, serialNumber, startDate, expirationDate, name, this.keyPair.getPublic());
        ASN1EncodableVector purposes = new ASN1EncodableVector();
        purposes.add((ASN1Encodable)KeyPurposeId.id_kp_serverAuth);
        purposes.add((ASN1Encodable)KeyPurposeId.id_kp_clientAuth);
        purposes.add((ASN1Encodable)KeyPurposeId.anyExtendedKeyUsage);
        ASN1ObjectIdentifier extendedKeyUsage = new ASN1ObjectIdentifier("2.5.29.37").intern();
        certGen.addExtension(extendedKeyUsage, false, (ASN1Encodable)new DERSequence(purposes));
        X509CertificateHolder certHolder = certGen.build(new JcaContentSignerBuilder(this.signatureAlgorithm.getAlgorithm()).setProvider(SecurityProviderUtility.getBCProviderName()).build(this.keyPair.getPrivate()));
        X509Certificate x509Certificate = new JcaX509CertificateConverter().setProvider(SecurityProviderUtility.getBCProviderName()).getCertificate(certHolder);
        return new Certificate(this.signatureAlgorithm, x509Certificate);
    }

    @Override
    public ECDSAPrivateKey getPrivateKey() {
        return this.ecdsaPrivateKey;
    }

    @Override
    public ECDSAPublicKey getPublicKey() {
        return this.ecdsaPublicKey;
    }

    @Override
    public Certificate getCertificate() {
        return this.certificate;
    }
}

