/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.crypto.encryption;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import org.gluu.oxauth.model.jwk.Algorithm;

public enum KeyEncryptionAlgorithm {
    RSA1_5("RSA1_5", "RSA", "RSA/ECB/PKCS1Padding"),
    RSA_OAEP("RSA-OAEP", "RSA", "RSA/ECB/OAEPWithSHA1AndMGF1Padding"),
    A128KW("A128KW"),
    A256KW("A256KW");

    private final String name;
    private final String family;
    private final String algorithm;
    private final Algorithm alg;

    private KeyEncryptionAlgorithm(String name) {
        this.name = name;
        this.family = null;
        this.algorithm = null;
        this.alg = Algorithm.fromString(name);
    }

    private KeyEncryptionAlgorithm(String name, String family, String algorithm) {
        this.name = name;
        this.family = family;
        this.algorithm = algorithm;
        this.alg = Algorithm.fromString(name);
    }

    public Algorithm getAlg() {
        return this.alg;
    }

    public String getName() {
        return this.name;
    }

    public String getFamily() {
        return this.family;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    @JsonCreator
    public static KeyEncryptionAlgorithm fromName(String name) {
        if (name != null) {
            for (KeyEncryptionAlgorithm a : KeyEncryptionAlgorithm.values()) {
                if (!name.equals(a.name)) continue;
                return a;
            }
        }
        return null;
    }

    @JsonValue
    public String toString() {
        return this.name;
    }
}

