/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.crypto.encryption;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum BlockEncryptionAlgorithm {
    A128CBC_PLUS_HS256("A128CBC+HS256", "CBC", "AES/CBC/PKCS5Padding", "SHA-256", "HMACSHA256", 256, 128, 128),
    A256CBC_PLUS_HS512("A256CBC+HS512", "CBC", "AES/CBC/PKCS5Padding", "SHA-512", "HMACSHA512", 512, 128, 256),
    A128GCM("A128GCM", "GCM", "AES/GCM/NoPadding", 128, 96),
    A256GCM("A256GCM", "GCM", "AES/GCM/NoPadding", 256, 96);

    private final String name;
    private final String family;
    private final String algorithm;
    private final String messageDiggestAlgorithm;
    private final String integrityValueAlgorithm;
    private final int cmkLength;
    private final int initVectorLength;
    private final Integer cekLength;

    private BlockEncryptionAlgorithm(String name, String family, String algorithm, int cmkLength, int initVectorLength) {
        this.name = name;
        this.family = family;
        this.algorithm = algorithm;
        this.messageDiggestAlgorithm = null;
        this.integrityValueAlgorithm = null;
        this.cmkLength = cmkLength;
        this.initVectorLength = initVectorLength;
        this.cekLength = null;
    }

    private BlockEncryptionAlgorithm(String name, String family, String algorithm, String messageDiggestAlgorithm, String integrityValueAlgorithm, int cmkLength, int initVectorLength, int cekLength) {
        this.name = name;
        this.family = family;
        this.algorithm = algorithm;
        this.messageDiggestAlgorithm = messageDiggestAlgorithm;
        this.integrityValueAlgorithm = integrityValueAlgorithm;
        this.cmkLength = cmkLength;
        this.initVectorLength = initVectorLength;
        this.cekLength = cekLength;
    }

    public String getName() {
        return this.name;
    }

    public String getFamily() {
        return this.family;
    }

    public String getMessageDiggestAlgorithm() {
        return this.messageDiggestAlgorithm;
    }

    public String getIntegrityValueAlgorithm() {
        return this.integrityValueAlgorithm;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public int getCmkLength() {
        return this.cmkLength;
    }

    public int getInitVectorLength() {
        return this.initVectorLength;
    }

    public Integer getCekLength() {
        return this.cekLength;
    }

    @JsonCreator
    public static BlockEncryptionAlgorithm fromName(String name) {
        if (name != null) {
            for (BlockEncryptionAlgorithm a : BlockEncryptionAlgorithm.values()) {
                if (!name.equals(a.name)) continue;
                return a;
            }
        }
        return null;
    }

    @JsonValue
    public String toString() {
        return this.name;
    }
}

