/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.crypto.binding;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.gluu.oxauth.model.crypto.binding.TokenBinding;
import org.gluu.oxauth.model.crypto.binding.TokenBindingMessageParser;
import org.gluu.oxauth.model.crypto.binding.TokenBindingParseException;
import org.gluu.oxauth.model.crypto.binding.TokenBindingType;
import org.gluu.oxauth.model.token.JsonWebResponse;
import org.json.JSONException;
import org.json.JSONObject;

public class TokenBindingMessage {
    private static final Logger log = Logger.getLogger(TokenBindingMessage.class);
    private List<TokenBinding> tokenBindings = new ArrayList<TokenBinding>();

    public TokenBindingMessage(String base64urlencoded) throws TokenBindingParseException {
        this(TokenBindingMessageParser.parseBase64UrlEncoded(base64urlencoded));
    }

    public TokenBindingMessage(byte[] raw) throws TokenBindingParseException {
        this(TokenBindingMessageParser.parseBytes(raw));
    }

    public TokenBindingMessage(List<TokenBinding> tokenBindings) {
        this.tokenBindings = tokenBindings;
    }

    public List<TokenBinding> getTokenBindings() {
        return this.tokenBindings;
    }

    public TokenBinding getFirstTokenBindingByType(TokenBindingType type) {
        for (TokenBinding binding : this.tokenBindings) {
            if (binding.getTokenBindingType() != type) continue;
            return binding;
        }
        return null;
    }

    public static Function<JsonWebResponse, Void> createIdTokenTokingBindingPreprocessing(String tokenBindingMessageAsString, final String rpTokenBindingMessageHashClaimKey) throws TokenBindingParseException {
        boolean tokenBindingMessagePresent = StringUtils.isNotBlank((String)tokenBindingMessageAsString);
        boolean rpKeyPresent = StringUtils.isNotBlank((String)rpTokenBindingMessageHashClaimKey);
        log.trace((Object)("TokenBindingMessage present: " + tokenBindingMessagePresent + ", rpCnfKey: " + rpTokenBindingMessageHashClaimKey));
        if (tokenBindingMessagePresent && rpKeyPresent) {
            TokenBindingMessage message = new TokenBindingMessage(tokenBindingMessageAsString);
            final TokenBinding referredBinding = message.getFirstTokenBindingByType(TokenBindingType.REFERRED_TOKEN_BINDING);
            return new Function<JsonWebResponse, Void>(){

                public Void apply(JsonWebResponse jsonWebResponse) {
                    TokenBindingMessage.setCnfClaim(jsonWebResponse, referredBinding.getTokenBindingID().sha256base64url(), rpTokenBindingMessageHashClaimKey);
                    return null;
                }
            };
        }
        return null;
    }

    public static void setCnfClaim(JsonWebResponse jsonWebResponse, String tokenBindingIdHash, String rpTokenBindingMessageHashClaimKey) {
        try {
            JSONObject value = jsonWebResponse.getClaims().getClaimAsJSON("cnf");
            if (value == null) {
                value = new JSONObject();
            }
            value.put(rpTokenBindingMessageHashClaimKey, (Object)tokenBindingIdHash);
            jsonWebResponse.getClaims().setClaim("cnf", value);
        }
        catch (JSONException e) {
            log.error((Object)"Failed to create cnf JSON object", (Throwable)e);
        }
    }

    public static String getTokenBindingIdHashFromTokenBindingMessage(String tokenBindingMessageAsString, String rpTokenBindingMessageHashClaimKey) throws TokenBindingParseException {
        if (StringUtils.isNotBlank((String)tokenBindingMessageAsString) && StringUtils.isNotBlank((String)rpTokenBindingMessageHashClaimKey)) {
            TokenBindingMessage message = new TokenBindingMessage(tokenBindingMessageAsString);
            TokenBinding referredBinding = message.getFirstTokenBindingByType(TokenBindingType.REFERRED_TOKEN_BINDING);
            return referredBinding.getTokenBindingID().sha256base64url();
        }
        return null;
    }

    public String toString() {
        return "TokenBindingMessage{tokenBindings=" + this.tokenBindings + '}';
    }
}

