/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.crypto.binding;

public enum TokenBindingKeyParameters {
    RSA2048_PKCS1_5("rsa2048_pkcs1.5", 0),
    RSA2048_PSS("rsa2048_pss", 1),
    ECDSAP256("ecdsap256", 2);

    private final String value;
    private final int byteValue;

    private TokenBindingKeyParameters(String value, int byteValue) {
        this.value = value;
        this.byteValue = byteValue;
    }

    public String getValue() {
        return this.value;
    }

    public int getByteValue() {
        return this.byteValue;
    }

    public static TokenBindingKeyParameters valueOf(int byteValue) {
        for (TokenBindingKeyParameters v : TokenBindingKeyParameters.values()) {
            if (v.getByteValue() != byteValue) continue;
            return v;
        }
        throw new RuntimeException("Failed to identify TokenBindingKeyParameters by byteValue");
    }

    public String toString() {
        return "TokenBindingKeyParameters{value='" + this.value + '\'' + ", byteValue=" + this.byteValue + "} " + super.toString();
    }
}

