/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.crypto;

import java.security.PrivateKey;
import org.gluu.oxauth.model.crypto.AbstractCryptoProvider;
import org.gluu.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.gluu.oxauth.model.jwk.Algorithm;
import org.gluu.oxauth.model.jwk.Use;
import org.gluu.oxeleven.client.DeleteKeyClient;
import org.gluu.oxeleven.client.DeleteKeyRequest;
import org.gluu.oxeleven.client.DeleteKeyResponse;
import org.gluu.oxeleven.client.GenerateKeyClient;
import org.gluu.oxeleven.client.GenerateKeyRequest;
import org.gluu.oxeleven.client.GenerateKeyResponse;
import org.gluu.oxeleven.client.SignClient;
import org.gluu.oxeleven.client.SignRequest;
import org.gluu.oxeleven.client.SignResponse;
import org.gluu.oxeleven.client.VerifySignatureClient;
import org.gluu.oxeleven.client.VerifySignatureRequest;
import org.gluu.oxeleven.client.VerifySignatureResponse;
import org.json.JSONObject;

public class OxElevenCryptoProvider
extends AbstractCryptoProvider {
    private String generateKeyEndpoint;
    private String signEndpoint;
    private String verifySignatureEndpoint;
    private String deleteKeyEndpoint;
    private String accessToken;

    public OxElevenCryptoProvider(String generateKeyEndpoint, String signEndpoint, String verifySignatureEndpoint, String deleteKeyEndpoint, String accessToken) {
        this.generateKeyEndpoint = generateKeyEndpoint;
        this.signEndpoint = signEndpoint;
        this.verifySignatureEndpoint = verifySignatureEndpoint;
        this.deleteKeyEndpoint = deleteKeyEndpoint;
        this.accessToken = accessToken;
    }

    @Override
    public boolean containsKey(String keyId) {
        return false;
    }

    @Override
    public JSONObject generateKey(Algorithm algorithm, Long expirationTime, Use use) throws Exception {
        return this.generateKey(algorithm, expirationTime, use, 2048);
    }

    @Override
    public JSONObject generateKey(Algorithm algorithm, Long expirationTime, Use use, int keyLength) throws Exception {
        GenerateKeyRequest request = new GenerateKeyRequest();
        request.setSignatureAlgorithm(algorithm.toString());
        request.setExpirationTime(expirationTime);
        request.setAccessToken(this.accessToken);
        GenerateKeyClient client = new GenerateKeyClient(this.generateKeyEndpoint);
        client.setRequest(request);
        GenerateKeyResponse response = client.exec();
        if (response.getStatus() == 200 && response.getKeyId() != null) {
            return response.getJSONEntity();
        }
        throw new Exception(response.getEntity());
    }

    @Override
    public String sign(String signingInput, String keyId, String shardSecret, SignatureAlgorithm signatureAlgorithm) throws Exception {
        SignRequest request = new SignRequest();
        request.getSignRequestParam().setSigningInput(signingInput);
        request.getSignRequestParam().setAlias(keyId);
        request.getSignRequestParam().setSharedSecret(shardSecret);
        request.getSignRequestParam().setSignatureAlgorithm(signatureAlgorithm.getName());
        request.setAccessToken(this.accessToken);
        SignClient client = new SignClient(this.signEndpoint);
        client.setRequest(request);
        SignResponse response = client.exec();
        if (response.getStatus() == 200 && response.getSignature() != null) {
            return response.getSignature();
        }
        throw new Exception(response.getEntity());
    }

    @Override
    public boolean verifySignature(String signingInput, String encodedSignature, String keyId, JSONObject jwks, String sharedSecret, SignatureAlgorithm signatureAlgorithm) throws Exception {
        VerifySignatureRequest request = new VerifySignatureRequest();
        request.getVerifySignatureRequestParam().setSigningInput(signingInput);
        request.getVerifySignatureRequestParam().setSignature(encodedSignature);
        request.getVerifySignatureRequestParam().setAlias(keyId);
        request.getVerifySignatureRequestParam().setSharedSecret(sharedSecret);
        request.getVerifySignatureRequestParam().setSignatureAlgorithm(signatureAlgorithm.getName());
        request.setAccessToken(this.accessToken);
        if (jwks != null) {
            request.getVerifySignatureRequestParam().setJwksRequestParam(this.getJwksRequestParam(jwks));
        }
        VerifySignatureClient client = new VerifySignatureClient(this.verifySignatureEndpoint);
        client.setRequest(request);
        VerifySignatureResponse response = client.exec();
        if (response.getStatus() == 200) {
            return response.isVerified();
        }
        throw new Exception(response.getEntity());
    }

    @Override
    public boolean deleteKey(String keyId) throws Exception {
        DeleteKeyRequest request = new DeleteKeyRequest();
        request.setAlias(keyId);
        request.setAccessToken(this.accessToken);
        DeleteKeyClient client = new DeleteKeyClient(this.deleteKeyEndpoint);
        client.setRequest(request);
        DeleteKeyResponse response = client.exec();
        if (response.getStatus() == 200) {
            return response.isDeleted();
        }
        throw new Exception(response.getEntity());
    }

    @Override
    public PrivateKey getPrivateKey(String keyId) {
        throw new UnsupportedOperationException("Method not implemented.");
    }
}

