/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.crypto;

import org.apache.commons.lang.StringUtils;
import org.gluu.oxauth.model.common.WebKeyStorage;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.crypto.AbstractCryptoProvider;
import org.gluu.oxauth.model.crypto.OxAuthCryptoProvider;
import org.gluu.oxauth.model.crypto.OxElevenCryptoProvider;

public class CryptoProviderFactory {
    private static OxAuthCryptoProvider keyStoreProvider = null;

    public static AbstractCryptoProvider getCryptoProvider(AppConfiguration configuration) throws Exception {
        AbstractCryptoProvider cryptoProvider = null;
        WebKeyStorage webKeyStorage = configuration.getWebKeysStorage();
        if (webKeyStorage == null) {
            return null;
        }
        switch (webKeyStorage) {
            case KEYSTORE: {
                cryptoProvider = CryptoProviderFactory.getKeyStoreProvider(configuration);
                break;
            }
            case PKCS11: {
                cryptoProvider = new OxElevenCryptoProvider(configuration.getOxElevenGenerateKeyEndpoint(), configuration.getOxElevenSignEndpoint(), configuration.getOxElevenVerifySignatureEndpoint(), configuration.getOxElevenDeleteKeyEndpoint(), configuration.getOxElevenTestModeToken());
            }
        }
        if (configuration.getKeyRegenerationEnabled().booleanValue()) {
            cryptoProvider.setKeyRegenerationIntervalInDays(configuration.getKeyRegenerationInterval() / 24);
        }
        return cryptoProvider;
    }

    private static AbstractCryptoProvider getKeyStoreProvider(AppConfiguration configuration) throws Exception {
        if (keyStoreProvider != null && StringUtils.isNotBlank((String)keyStoreProvider.getKeyStoreFile()) && StringUtils.isNotBlank((String)keyStoreProvider.getKeyStoreSecret()) && StringUtils.isNotBlank((String)keyStoreProvider.getDnName()) && keyStoreProvider.getKeyStoreFile().equals(configuration.getKeyStoreFile()) && keyStoreProvider.getKeyStoreSecret().equals(configuration.getKeyStoreSecret()) && keyStoreProvider.getDnName().equals(configuration.getDnName())) {
            return keyStoreProvider;
        }
        keyStoreProvider = new OxAuthCryptoProvider(configuration.getKeyStoreFile(), configuration.getKeyStoreSecret(), configuration.getDnName(), configuration.getRejectJwtWithNoneAlg(), configuration.getKeySelectionStrategy());
        return keyStoreProvider;
    }

    public static void reset() {
        keyStoreProvider = null;
    }
}

