/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.crypto;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.util.Arrays;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.gluu.oxauth.model.crypto.PublicKey;
import org.gluu.oxauth.model.crypto.signature.ECDSAPublicKey;
import org.gluu.oxauth.model.crypto.signature.RSAPublicKey;
import org.gluu.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.json.JSONArray;
import org.json.JSONException;

public class Certificate {
    private SignatureAlgorithm signatureAlgorithm;
    private X509Certificate x509Certificate;

    public Certificate(SignatureAlgorithm signatureAlgorithm, X509Certificate x509Certificate) {
        this.signatureAlgorithm = signatureAlgorithm;
        this.x509Certificate = x509Certificate;
    }

    public PublicKey getPublicKey() {
        PublicKey publicKey = null;
        if (this.x509Certificate != null && this.x509Certificate.getPublicKey() instanceof java.security.interfaces.RSAPublicKey) {
            java.security.interfaces.RSAPublicKey jcersaPublicKey = (java.security.interfaces.RSAPublicKey)this.x509Certificate.getPublicKey();
            publicKey = new RSAPublicKey(jcersaPublicKey.getModulus(), jcersaPublicKey.getPublicExponent());
        } else if (this.x509Certificate != null && this.x509Certificate.getPublicKey() instanceof ECPublicKey) {
            ECPublicKey jceecPublicKey = (ECPublicKey)this.x509Certificate.getPublicKey();
            publicKey = new ECDSAPublicKey(this.signatureAlgorithm, jceecPublicKey.getW().getAffineX(), jceecPublicKey.getW().getAffineY());
        }
        return publicKey;
    }

    public RSAPublicKey getRsaPublicKey() {
        RSAPublicKey rsaPublicKey = null;
        if (this.x509Certificate != null && this.x509Certificate.getPublicKey() instanceof java.security.interfaces.RSAPublicKey) {
            java.security.interfaces.RSAPublicKey publicKey = (java.security.interfaces.RSAPublicKey)this.x509Certificate.getPublicKey();
            rsaPublicKey = new RSAPublicKey(publicKey.getModulus(), publicKey.getPublicExponent());
        }
        return rsaPublicKey;
    }

    public ECDSAPublicKey getEcdsaPublicKey() {
        ECDSAPublicKey ecdsaPublicKey = null;
        if (this.x509Certificate != null && this.x509Certificate.getPublicKey() instanceof ECPublicKey) {
            ECPublicKey publicKey = (ECPublicKey)this.x509Certificate.getPublicKey();
            ecdsaPublicKey = new ECDSAPublicKey(this.signatureAlgorithm, publicKey.getW().getAffineX(), publicKey.getW().getAffineY());
        }
        return ecdsaPublicKey;
    }

    public JSONArray toJSONArray() throws JSONException {
        String cert = this.toString();
        cert = cert.replace("\n", "");
        cert = cert.replace("-----BEGIN CERTIFICATE-----", "");
        cert = cert.replace("-----END CERTIFICATE-----", "");
        return new JSONArray(Arrays.asList(cert));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String string;
        StringWriter stringWriter = new StringWriter();
        JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)stringWriter);
        try {
            pemWriter.writeObject((Object)this.x509Certificate);
            pemWriter.flush();
            string = stringWriter.toString();
        }
        catch (Throwable throwable) {
            try {
                pemWriter.close();
                throw throwable;
            }
            catch (IOException e) {
                return "";
            }
            catch (Exception e) {
                return "";
            }
        }
        pemWriter.close();
        return string;
    }
}

