/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.crypto;

import com.google.common.collect.Lists;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import org.apache.log4j.Logger;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.crypto.signature.AlgorithmFamily;
import org.gluu.oxauth.model.crypto.signature.ECEllipticCurve;
import org.gluu.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.gluu.oxauth.model.jwk.Algorithm;
import org.gluu.oxauth.model.jwk.JSONWebKey;
import org.gluu.oxauth.model.jwk.JSONWebKeySet;
import org.gluu.oxauth.model.jwk.Use;
import org.gluu.oxauth.model.util.Base64Util;
import org.gluu.oxeleven.model.JwksRequestParam;
import org.gluu.oxeleven.model.KeyRequestParam;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class AbstractCryptoProvider {
    protected static final Logger LOG = Logger.getLogger(AbstractCryptoProvider.class);
    private int keyRegenerationIntervalInDays = -1;

    public JSONObject generateKey(Algorithm algorithm, Long expirationTime) throws Exception {
        return this.generateKey(algorithm, expirationTime, Use.SIGNATURE);
    }

    public abstract JSONObject generateKey(Algorithm var1, Long var2, Use var3) throws Exception;

    public abstract JSONObject generateKey(Algorithm var1, Long var2, Use var3, int var4) throws Exception;

    public abstract String sign(String var1, String var2, String var3, SignatureAlgorithm var4) throws Exception;

    public abstract boolean verifySignature(String var1, String var2, String var3, JSONObject var4, String var5, SignatureAlgorithm var6) throws Exception;

    public abstract boolean deleteKey(String var1) throws Exception;

    public abstract boolean containsKey(String var1);

    public List<String> getKeys() {
        return Lists.newArrayList();
    }

    public abstract PrivateKey getPrivateKey(String var1) throws Exception;

    public String getKeyId(JSONWebKeySet jsonWebKeySet, Algorithm algorithm, Use use) throws Exception {
        if (algorithm == null || AlgorithmFamily.HMAC.equals((Object)algorithm.getFamily())) {
            return null;
        }
        for (JSONWebKey key : jsonWebKeySet.getKeys()) {
            if (algorithm != key.getAlg() || use != null && use != key.getUse()) continue;
            return key.getKid();
        }
        return null;
    }

    public JwksRequestParam getJwksRequestParam(JSONObject jwkJsonObject) throws JSONException {
        JwksRequestParam jwks = new JwksRequestParam();
        jwks.setKeyRequestParams(new ArrayList());
        KeyRequestParam key = new KeyRequestParam();
        key.setAlg(jwkJsonObject.getString("alg"));
        key.setKid(jwkJsonObject.getString("kid"));
        key.setUse(jwkJsonObject.getString("use"));
        key.setKty(jwkJsonObject.getString("kty"));
        key.setN(jwkJsonObject.optString("n"));
        key.setE(jwkJsonObject.optString("e"));
        key.setCrv(jwkJsonObject.optString("crv"));
        key.setX(jwkJsonObject.optString("x"));
        key.setY(jwkJsonObject.optString("y"));
        jwks.getKeyRequestParams().add(key);
        return jwks;
    }

    public static JSONObject generateJwks(AbstractCryptoProvider cryptoProvider, AppConfiguration configuration) {
        GregorianCalendar expirationTime = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        expirationTime.add(10, configuration.getKeyRegenerationInterval());
        expirationTime.add(13, configuration.getIdTokenLifetime());
        long expiration = expirationTime.getTimeInMillis();
        List<String> allowedAlgs = configuration.getKeyAlgsAllowedForGeneration();
        JSONArray keys = new JSONArray();
        for (Algorithm alg : Algorithm.values()) {
            try {
                if (!allowedAlgs.isEmpty() && !allowedAlgs.contains(alg.getParamName())) {
                    LOG.debug((Object)("Key generation for " + (Object)((Object)alg) + " is skipped because it's not allowed by keyAlgsAllowedForGeneration configuration property."));
                    continue;
                }
                keys.put((Object)cryptoProvider.generateKey(alg, expiration, alg.getUse()));
            }
            catch (Exception ex) {
                LOG.error((Object)("Algorithm: " + (Object)((Object)alg) + ex.getMessage()), (Throwable)ex);
            }
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("keys", (Object)keys);
        return jsonObject;
    }

    public PublicKey getPublicKey(String alias, JSONObject jwks, Algorithm requestedAlgorithm) throws Exception {
        PublicKey publicKey = null;
        JSONArray webKeys = jwks.getJSONArray("keys");
        for (int i = 0; i < webKeys.length(); ++i) {
            JSONObject key = webKeys.getJSONObject(i);
            if (!alias.equals(key.getString("kid"))) continue;
            AlgorithmFamily family = null;
            if (key.has("alg")) {
                Algorithm algorithm = Algorithm.fromString(key.optString("alg"));
                if (requestedAlgorithm != null && algorithm != requestedAlgorithm) {
                    LOG.trace((Object)("kid matched but algorithm does not match. kid algorithm:" + (Object)((Object)algorithm) + ", requestedAlgorithm:" + (Object)((Object)requestedAlgorithm) + ", kid:" + alias));
                    continue;
                }
                family = algorithm.getFamily();
            } else if (key.has("kty")) {
                family = AlgorithmFamily.fromString(key.getString("kty"));
            }
            if (AlgorithmFamily.RSA.equals((Object)family)) {
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                RSAPublicKeySpec pubKeySpec = new RSAPublicKeySpec(new BigInteger(1, Base64Util.base64urldecode(key.getString("n"))), new BigInteger(1, Base64Util.base64urldecode(key.getString("e"))));
                publicKey = keyFactory.generatePublic(pubKeySpec);
            } else if (AlgorithmFamily.EC.equals((Object)family)) {
                ECEllipticCurve curve = ECEllipticCurve.fromString(key.optString("crv"));
                AlgorithmParameters parameters = AlgorithmParameters.getInstance(AlgorithmFamily.EC.toString());
                parameters.init(new ECGenParameterSpec(curve.getAlias()));
                ECParameterSpec ecParameters = parameters.getParameterSpec(ECParameterSpec.class);
                publicKey = KeyFactory.getInstance(AlgorithmFamily.EC.toString()).generatePublic(new ECPublicKeySpec(new ECPoint(new BigInteger(1, Base64Util.base64urldecode(key.getString("x"))), new BigInteger(1, Base64Util.base64urldecode(key.getString("y")))), ecParameters));
            }
            if (!key.has("exp")) continue;
            this.checkKeyExpiration(alias, key.getLong("exp"));
        }
        if (publicKey == null && LOG.isTraceEnabled()) {
            ArrayList<String> jwksKeys = new ArrayList<String>();
            for (int i = 0; i < webKeys.length(); ++i) {
                JSONObject key = webKeys.getJSONObject(i);
                jwksKeys.add(key.getString("kid"));
            }
            LOG.trace((Object)("Failed to find key: " + alias + " in jwks keys:" + jwksKeys));
        }
        return publicKey;
    }

    protected void checkKeyExpiration(String alias, Long expirationTime) {
        try {
            Date expirationDate = new Date(expirationTime);
            SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date today = new Date();
            long expiresInDays = (expirationTime - today.getTime()) / 86400000L;
            if (expiresInDays == 0L) {
                LOG.warn((Object)("\nWARNING! Key will expire soon, alias: " + alias + "\n\tExpires On: " + ft.format(expirationDate) + "\n\tToday's Date: " + ft.format(today)));
                return;
            }
            if (expiresInDays < 0L) {
                LOG.warn((Object)("\nWARNING! Expired Key is used, alias: " + alias + "\n\tExpires On: " + ft.format(expirationDate) + "\n\tToday's Date: " + ft.format(today)));
                return;
            }
            if (this.keyRegenerationIntervalInDays <= 0 && expiresInDays < 30L) {
                LOG.warn((Object)("\nWARNING! Key with alias: " + alias + "\n\tExpires In: " + expiresInDays + " days\n\tExpires On: " + ft.format(expirationDate) + "\n\tToday's Date: " + ft.format(today)));
                return;
            }
            if (expiresInDays < (long)this.keyRegenerationIntervalInDays) {
                LOG.warn((Object)("\nWARNING! Key with alias: " + alias + "\n\tExpires In: " + expiresInDays + " days\n\tExpires On: " + ft.format(expirationDate) + "\n\tKey Regeneration In: " + this.keyRegenerationIntervalInDays + " days\n\tToday's Date: " + ft.format(today)));
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to check key expiration.", (Throwable)e);
        }
    }

    public int getKeyRegenerationIntervalInDays() {
        return this.keyRegenerationIntervalInDays;
    }

    public void setKeyRegenerationIntervalInDays(int keyRegenerationIntervalInDays) {
        this.keyRegenerationIntervalInDays = keyRegenerationIntervalInDays;
    }
}

