/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.common.converter;

import com.fasterxml.jackson.databind.util.StdConverter;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gluu.oxauth.model.util.StringUtils;

public class ListConverter
extends StdConverter<Object, List<String>> {
    public List<String> convert(Object obj) {
        if (obj != null) {
            if (List.class.isAssignableFrom(obj.getClass())) {
                Stream<Object> stream = ((List)List.class.cast(obj)).stream().filter(Objects::nonNull).map(Object::toString);
                return stream.collect(Collectors.toList());
            }
            if (String.class.equals(obj.getClass())) {
                return StringUtils.spaceSeparatedToList(obj.toString());
            }
        }
        return null;
    }
}

