/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum WebKeyStorage {
    KEYSTORE("keystore"),
    PKCS11("pkcs11");

    private final String value;

    private WebKeyStorage(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    @JsonCreator
    public static WebKeyStorage fromString(String string) {
        for (WebKeyStorage v : WebKeyStorage.values()) {
            if (!v.getValue().equalsIgnoreCase(string)) continue;
            return v;
        }
        return KEYSTORE;
    }

    @JsonValue
    public String toString() {
        return this.value;
    }
}

