/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import org.gluu.oxauth.model.common.HasParamName;
import org.gluu.persist.annotation.AttributeEnum;

public enum TokenTypeHint implements HasParamName,
AttributeEnum
{
    ACCESS_TOKEN("access_token"),
    REFRESH_TOKEN("refresh_token");

    private final String value;
    private static Map<String, TokenTypeHint> mapByValues;

    private TokenTypeHint(String value) {
        this.value = value;
    }

    @Override
    public String getParamName() {
        return this.value;
    }

    public String getValue() {
        return this.value;
    }

    @JsonCreator
    public static TokenTypeHint fromString(String param) {
        if (param != null) {
            for (TokenTypeHint tth : TokenTypeHint.values()) {
                if (!param.equals(tth.value)) continue;
                return tth;
            }
        }
        return null;
    }

    public static TokenTypeHint getByValue(String value) {
        return mapByValues.get(value);
    }

    public Enum<? extends AttributeEnum> resolveByValue(String s) {
        return TokenTypeHint.getByValue(this.value);
    }

    @JsonValue
    public String toString() {
        return this.value;
    }

    static {
        mapByValues = new HashMap<String, TokenTypeHint>();
        for (TokenTypeHint enumType : TokenTypeHint.values()) {
            mapByValues.put(enumType.getValue(), enumType);
        }
    }
}

