/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import org.gluu.persist.annotation.AttributeEnum;

public enum ScopeType implements AttributeEnum
{
    OPENID("openid", "OpenID"),
    DYNAMIC("dynamic", "Dynamic"),
    UMA("uma", "UMA"),
    SPONTANEOUS("spontaneous", "Spontaneous"),
    OAUTH("oauth", "OAuth");

    private final String value;
    private final String displayName;
    private static Map<String, ScopeType> mapByValues;

    private ScopeType(String value, String displayName) {
        this.value = value;
        this.displayName = displayName;
    }

    @JsonCreator
    public static ScopeType fromString(String param) {
        if (param != null) {
            for (ScopeType st : ScopeType.values()) {
                if (!param.equals(st.value)) continue;
                return st;
            }
        }
        return null;
    }

    public String getValue() {
        return this.value;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static ScopeType getByValue(String value) {
        return mapByValues.get(value);
    }

    public Enum<? extends AttributeEnum> resolveByValue(String value) {
        return ScopeType.getByValue(value);
    }

    @JsonValue
    public String toString() {
        return this.value;
    }

    static {
        mapByValues = new HashMap<String, ScopeType>();
        for (ScopeType enumType : ScopeType.values()) {
            mapByValues.put(enumType.getValue(), enumType);
        }
    }
}

