/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import org.gluu.oxauth.model.common.HasParamName;
import org.gluu.persist.annotation.AttributeEnum;

public enum ResponseMode implements HasParamName,
AttributeEnum
{
    QUERY("query"),
    FRAGMENT("fragment"),
    FORM_POST("form_post");

    private final String value;
    private static Map<String, ResponseMode> mapByValues;

    private ResponseMode(String value) {
        this.value = value;
    }

    public static ResponseMode getByValue(String value) {
        return mapByValues.get(value);
    }

    @JsonCreator
    public static ResponseMode fromString(String param) {
        if (param != null) {
            for (ResponseMode rm : ResponseMode.values()) {
                if (!param.equals(rm.value)) continue;
                return rm;
            }
        }
        return null;
    }

    @Override
    public String getParamName() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.value;
    }

    public String getValue() {
        return this.value;
    }

    public Enum<? extends AttributeEnum> resolveByValue(String value) {
        return ResponseMode.getByValue(value);
    }

    static {
        mapByValues = new HashMap<String, ResponseMode>();
        for (ResponseMode enumType : ResponseMode.values()) {
            mapByValues.put(enumType.getParamName(), enumType);
        }
    }
}

