/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import org.gluu.oxauth.model.common.HasParamName;

public enum Prompt implements HasParamName
{
    NONE("none"),
    LOGIN("login"),
    CONSENT("consent"),
    SELECT_ACCOUNT("select_account");

    private final String paramName;

    private Prompt(String paramName) {
        this.paramName = paramName;
    }

    public static Prompt fromString(String param) {
        if (param != null) {
            for (Prompt rt : Prompt.values()) {
                if (!param.equals(rt.paramName)) continue;
                return rt;
            }
        }
        return null;
    }

    @Override
    public String getParamName() {
        return this.paramName;
    }

    @JsonCreator
    public static List<Prompt> fromString(String paramList, String separator) {
        ArrayList<Prompt> prompts = new ArrayList<Prompt>();
        if (paramList != null && !paramList.isEmpty()) {
            String[] params;
            for (String param : params = paramList.split(separator)) {
                for (Prompt p : Prompt.values()) {
                    if (!param.equals(p.paramName) || prompts.contains(p)) continue;
                    prompts.add(p);
                }
            }
        }
        return prompts;
    }

    @JsonValue
    public String toString() {
        return this.paramName;
    }
}

