/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsonorg;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.datatype.jsonorg.JSONBaseSerializer;
import com.fasterxml.jackson.datatype.jsonorg.JSONObjectSerializer;
import java.io.IOException;
import java.lang.reflect.Type;
import org.json.JSONArray;
import org.json.JSONObject;

public class JSONArraySerializer
extends JSONBaseSerializer<JSONArray> {
    private static final long serialVersionUID = 1L;
    public static final JSONArraySerializer instance = new JSONArraySerializer();

    public JSONArraySerializer() {
        super(JSONArray.class);
    }

    public boolean isEmpty(SerializerProvider provider, JSONArray value) {
        return value == null || value.length() == 0;
    }

    public void serialize(JSONArray value, JsonGenerator g, SerializerProvider provider) throws IOException {
        g.writeStartArray();
        this.serializeContents(value, g, provider);
        g.writeEndArray();
    }

    public void serializeWithType(JSONArray value, JsonGenerator g, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        g.setCurrentValue((Object)value);
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g, typeSer.typeId((Object)value, JsonToken.START_ARRAY));
        this.serializeContents(value, g, provider);
        typeSer.writeTypeSuffix(g, typeIdDef);
    }

    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        return this.createSchemaNode("array", true);
    }

    protected void serializeContents(JSONArray value, JsonGenerator g, SerializerProvider provider) throws IOException {
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            Object ob = value.opt(i);
            if (ob == null || ob == JSONObject.NULL) {
                g.writeNull();
                continue;
            }
            Class<?> cls = ob.getClass();
            if (cls == JSONObject.class) {
                JSONObjectSerializer.instance.serialize((JSONObject)ob, g, provider);
                continue;
            }
            if (cls == JSONArray.class) {
                this.serialize((JSONArray)ob, g, provider);
                continue;
            }
            if (cls == String.class) {
                g.writeString((String)ob);
                continue;
            }
            if (cls == Integer.class) {
                g.writeNumber(((Integer)ob).intValue());
                continue;
            }
            if (cls == Long.class) {
                g.writeNumber(((Long)ob).longValue());
                continue;
            }
            if (cls == Boolean.class) {
                g.writeBoolean(((Boolean)ob).booleanValue());
                continue;
            }
            if (cls == Double.class) {
                g.writeNumber(((Double)ob).doubleValue());
                continue;
            }
            if (JSONObject.class.isAssignableFrom(cls)) {
                JSONObjectSerializer.instance.serialize((JSONObject)ob, g, provider);
                continue;
            }
            if (JSONArray.class.isAssignableFrom(cls)) {
                this.serialize((JSONArray)ob, g, provider);
                continue;
            }
            provider.defaultSerializeValue(ob, g);
        }
    }
}

