/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.client.supergluu.impl.http;

import org.apache.http.client.CookieStore;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.cookie.DefaultCookieSpecProvider;
import org.apache.http.impl.cookie.RFC6265CookieSpecProvider;
import org.apache.http.protocol.HttpContext;
import org.jboss.resteasy.client.jaxrs.engines.HttpContextProvider;

public class HttpContextFactory
implements HttpContextProvider {
    private static final HttpContext newHttpContext() {
        HttpClientContext httpClientContext = new HttpClientContext();
        HttpContextFactory.configureCookieStorage(httpClientContext);
        HttpContextFactory.configureRequestConfig(httpClientContext);
        return httpClientContext;
    }

    private static final void configureCookieStorage(HttpClientContext httpClientContext) {
        Registry r = RegistryBuilder.create().register("default", (Object)new DefaultCookieSpecProvider()).register("standard", (Object)new RFC6265CookieSpecProvider()).build();
        httpClientContext.setCookieSpecRegistry((Lookup)r);
        httpClientContext.setCookieStore((CookieStore)new BasicCookieStore());
    }

    private static final void configureRequestConfig(HttpClientContext httpClientContext) {
        RequestConfig reqConfig = RequestConfig.custom().setCookieSpec("standard").build();
        httpClientContext.setRequestConfig(reqConfig);
    }

    public HttpContext getContext() {
        return HttpContextFactory.newHttpContext();
    }
}

