/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.client.supergluu.impl;

import java.io.Serializable;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.gluu.oxauth.client.BaseResponse;
import org.gluu.oxauth.client.supergluu.impl.model.SessionCustomState;
import org.gluu.oxauth.client.supergluu.impl.model.SessionState;
import org.json.JSONException;
import org.json.JSONObject;

public class SessionStatusResponse
extends BaseResponse
implements Serializable {
    private static final long serialVersionUID = -1L;
    private static final Logger log = Logger.getLogger(SessionStatusResponse.class);
    private SessionState state;
    private SessionCustomState customState;
    private Integer authTime;

    public SessionStatusResponse(Response clientResponse) {
        super(clientResponse);
        if (StringUtils.isNotBlank((String)this.entity)) {
            try {
                JSONObject jsonObj = new JSONObject(this.entity);
                if (jsonObj.has("state")) {
                    this.state = SessionState.fromString(jsonObj.getString("state"));
                }
                if (jsonObj.has("custom_state")) {
                    this.customState = SessionCustomState.fromString(jsonObj.getString("custom_state"));
                }
                if (jsonObj.has("auth_time") && !jsonObj.isNull("auth_time")) {
                    this.authTime = jsonObj.getInt("auth_time");
                }
            }
            catch (JSONException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public SessionState getState() {
        return this.state;
    }

    public SessionStatusResponse setState(SessionState state) {
        this.state = state;
        return this;
    }

    public SessionCustomState getCustomState() {
        return this.customState;
    }

    public SessionStatusResponse setCustomState(SessionCustomState customState) {
        this.customState = customState;
        return this;
    }

    public Integer getAuthTime() {
        return this.authTime;
    }

    public SessionStatusResponse setAuthTime(Integer authTime) {
        this.authTime = authTime;
        return this;
    }

    public boolean isAuthenticated() {
        if (this.checkIfNotAuthenticated()) {
            return false;
        }
        return this.checkIfAuthenticated();
    }

    private final boolean checkIfNotAuthenticated() {
        return this.state == SessionState.UNKNOWN || this.state == SessionState.UNAUTHENTICATED && (this.customState == SessionCustomState.DECLINED || this.customState == SessionCustomState.EXPIRED);
    }

    private final boolean checkIfAuthenticated() {
        return this.state == SessionState.AUTHENTICATED || this.state == SessionState.UNAUTHENTICATED && this.customState == SessionCustomState.APPROVED;
    }

    public String toString() {
        return "SessionStatusResponse{state='" + (Object)((Object)this.state) + "'custom_state='" + (Object)((Object)this.customState) + "'auth_time='" + this.authTime + "'}";
    }
}

