/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.client.supergluu.impl;

import java.net.URL;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.NewCookie;
import org.apache.log4j.Logger;
import org.gluu.oxauth.client.BaseClient;
import org.gluu.oxauth.client.supergluu.impl.SessionStatusRequest;
import org.gluu.oxauth.client.supergluu.impl.SessionStatusResponse;

public class SessionStatusClient
extends BaseClient<SessionStatusRequest, SessionStatusResponse> {
    private static final Logger log = Logger.getLogger(SessionStatusClient.class);
    private static final String mediaTypes = String.join((CharSequence)",", "text/plain", "application/json");
    private static final String sessionIdCookieName = "session_id";
    private static final int DEFAULT_COOKIE_DURATION = 3600;
    private String requestDomain = null;

    public SessionStatusClient(String url) {
        super(url);
        try {
            URL urlToDecode = new URL(url);
            this.requestDomain = urlToDecode.getHost();
        }
        catch (Exception e) {
            log.debug((Object)("Could not get domain from url. " + e.getMessage()), (Throwable)e);
            this.requestDomain = url;
        }
    }

    public String getHttpMethod() {
        return "GET";
    }

    public void setSessionId(String sessionId) {
        NewCookie sessionIdCookie = new NewCookie(sessionIdCookieName, sessionId, "/", this.requestDomain, "", 3600, true);
        this.getCookies().add(sessionIdCookie);
    }

    public SessionStatusResponse execGetStatus() {
        this.initClientRequest();
        Invocation.Builder clientRequest = this.webTarget.request();
        this.applyCookies(clientRequest);
        SessionStatusResponse response = null;
        try {
            response = this.execGetStatusImpl(clientRequest);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return response;
    }

    private final SessionStatusResponse execGetStatusImpl(Invocation.Builder clientRequest) throws Exception {
        this.setRequest(new SessionStatusRequest());
        clientRequest.accept(new String[]{mediaTypes});
        this.clientResponse = clientRequest.buildGet().invoke();
        this.setResponse(new SessionStatusResponse(this.clientResponse));
        return (SessionStatusResponse)this.getResponse();
    }
}

