/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.client.supergluu;

import org.apache.http.client.HttpClient;
import org.apache.log4j.Logger;
import org.gluu.oxauth.client.BaseRequest;
import org.gluu.oxauth.client.TokenClient;
import org.gluu.oxauth.client.TokenRequest;
import org.gluu.oxauth.client.TokenResponse;
import org.gluu.oxauth.client.supergluu.SuperGluuAuthClientConfig;
import org.gluu.oxauth.client.supergluu.SuperGluuAuthScheme;
import org.gluu.oxauth.client.supergluu.SuperGluuAuthStatus;
import org.gluu.oxauth.client.supergluu.impl.ICryptoProviderFactory;
import org.gluu.oxauth.client.supergluu.impl.IHttpClientFactory;
import org.gluu.oxauth.client.supergluu.impl.SessionStatusClient;
import org.gluu.oxauth.client.supergluu.impl.SessionStatusResponse;
import org.gluu.oxauth.client.supergluu.impl.http.HttpContextFactory;
import org.gluu.oxauth.model.common.AuthenticationMethod;
import org.gluu.oxauth.model.common.GrantType;
import org.gluu.oxauth.model.crypto.AbstractCryptoProvider;
import org.gluu.oxauth.model.exception.InvalidJwtException;
import org.gluu.oxauth.model.jwt.Jwt;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.engines.ApacheHttpClient43Engine;
import org.jboss.resteasy.client.jaxrs.engines.HttpContextProvider;
import org.json.JSONObject;

public class SuperGluuAuthClient {
    private static final String ACR_VALUES_PARAM_NAME = "acr_values";
    private static final String STEP_PARAM_NAME = "__step";
    private static final String PASSWORD_PARAM_NAME = "__password";
    private static final String SESSION_ID_PARAM_NAME = "__session_id";
    private static final String REMOTE_IP_PARAM_NAME = "__remote_ip";
    private static final String SESSION_ID_CLAIM_NAME = "__session_id";
    private static final String AUTH_SCHEME_PARAM_NAME = "__auth_scheme";
    private static final String INITIATE_AUTH_STEP_NAME = "initiate_auth";
    private static final String RESEND_NOTIFICATION_STEP_NAME = "resend_notification";
    private static final String VERIFY_AUTH_STEP_NAME = "verify_auth";
    private static final Logger log = Logger.getLogger(SuperGluuAuthClient.class);
    private AuthenticationContext authContext = new AuthenticationContext();
    private SuperGluuAuthClientConfig config;
    private AbstractCryptoProvider cryptoProvider;
    private TokenClient tokenClient;
    private SessionStatusClient sessionStatusClient;
    private JSONObject serverKeyset;
    private SuperGluuAuthScheme authScheme;

    public SuperGluuAuthClient(SuperGluuAuthClientConfig config, IHttpClientFactory httpClientFactory) {
        this.config = config;
        this.cryptoProvider = null;
        this.tokenClient = new TokenClient(config.getTokenEndpointUrl());
        this.tokenClient.setExecutor((ClientHttpEngine)this.createExecutor(httpClientFactory));
        this.sessionStatusClient = new SessionStatusClient(config.getSessionStatusUrl());
        this.sessionStatusClient.setExecutor((ClientHttpEngine)this.createExecutor(httpClientFactory, true));
        this.authScheme = SuperGluuAuthScheme.TWO_STEP;
    }

    public SuperGluuAuthClient(SuperGluuAuthClientConfig config, IHttpClientFactory httpClientFactory, ICryptoProviderFactory cryptoProviderFactory, JSONObject serverKeyset) {
        this.config = config;
        this.cryptoProvider = cryptoProviderFactory.newCryptoProvider();
        this.serverKeyset = serverKeyset;
        this.tokenClient = new TokenClient(config.getTokenEndpointUrl());
        this.tokenClient.setExecutor((ClientHttpEngine)this.createExecutor(httpClientFactory));
        this.sessionStatusClient = new SessionStatusClient(config.getSessionStatusUrl());
        this.sessionStatusClient.setExecutor((ClientHttpEngine)this.createExecutor(httpClientFactory, true));
        this.authScheme = SuperGluuAuthScheme.TWO_STEP;
    }

    public void setCryptoProvider(AbstractCryptoProvider cryptoProvider) {
        this.cryptoProvider = cryptoProvider;
    }

    public void setAuthScheme(SuperGluuAuthScheme authScheme) {
        this.authScheme = authScheme;
    }

    public Boolean initiateAuthentication(String username, String password) {
        return this.initiateAuthentication(username, password, null);
    }

    public Boolean initiateAuthentication(String username, String password, String userip) {
        TokenRequest request = this.createInitiateAuthTokenRequest(username, password, userip);
        this.tokenClient.setRequest((BaseRequest)request);
        TokenResponse response = this.tokenClient.exec();
        if (response == null || response != null && response.getStatus() != 200) {
            if (response != null) {
                log.debug((Object)("SuperGluu initial auth failed. Response: " + response.getEntity()));
            } else {
                log.debug((Object)"SuperGluu initial auth failed. No response");
            }
            return false;
        }
        if (this.authScheme == SuperGluuAuthScheme.ONE_STEP) {
            return true;
        }
        String idtoken = response.getIdToken();
        if (idtoken == null || idtoken != null && idtoken.isEmpty()) {
            log.debug((Object)("SuperGluu initial auth failed. No id_token returned. " + response.getEntity()));
            return false;
        }
        return this.extractSessionIdFromIdToken(idtoken);
    }

    public Boolean resendPushNotification(String username, String password) {
        return this.resendPushNotification(username, password, null);
    }

    public Boolean resendPushNotification(String username, String password, String userip) {
        TokenRequest request = this.createResendNotificationTokenRequest(username, password, userip);
        this.tokenClient.setRequest((BaseRequest)request);
        TokenResponse response = this.tokenClient.exec();
        if (response == null || response != null && response.getStatus() != 200) {
            if (response != null) {
                log.debug((Object)("SuperGluu resend push notification failed. Response: " + response.getEntity()));
            } else {
                log.debug((Object)"SuperGluu resend push notification failed. No response");
            }
            return false;
        }
        return this.verifyIdTokenSignature(response.getIdToken());
    }

    public Boolean verifyAuthentication(String username, String password) {
        TokenRequest request = this.createVerifyAuthTokenRequest(username, password);
        this.tokenClient.setRequest((BaseRequest)request);
        TokenResponse response = this.tokenClient.exec();
        if (response == null || response != null && response.getStatus() != 200) {
            if (response != null) {
                log.debug((Object)("SuperGluu auth verify failed. Response: " + response.getEntity()));
            } else {
                log.debug((Object)"SuperGluu auth verify failed. No response");
            }
            return false;
        }
        return this.verifyIdTokenSignature(response.getIdToken());
    }

    public SuperGluuAuthStatus checkAuthenticationStatus() {
        this.sessionStatusClient.setSessionId(this.authContext.getSessionId());
        SessionStatusResponse response = this.sessionStatusClient.execGetStatus();
        if (response == null || response != null && response.getStatus() != 200) {
            if (response != null) {
                log.debug((Object)("SuperGluu auth status check failed. Response: " + response.getEntity()));
            } else {
                log.debug((Object)"SuperGluu auth status check failed. No response");
            }
            return SuperGluuAuthStatus.UNAUTHENTICATED;
        }
        return response.isAuthenticated() ? SuperGluuAuthStatus.AUTHENTICATED : SuperGluuAuthStatus.UNAUTHENTICATED;
    }

    private final ApacheHttpClient43Engine createExecutor(IHttpClientFactory httpClientFactory) {
        return this.createExecutor(httpClientFactory, false);
    }

    private final ApacheHttpClient43Engine createExecutor(IHttpClientFactory httpClientFactory, boolean createContext) {
        if (createContext) {
            return new ApacheHttpClient43Engine((HttpClient)httpClientFactory.newHttpClient(), (HttpContextProvider)new HttpContextFactory());
        }
        return new ApacheHttpClient43Engine((HttpClient)httpClientFactory.newHttpClient());
    }

    private final TokenRequest createInitiateAuthTokenRequest(String username, String password, String userip) {
        TokenRequest request = new TokenRequest(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
        if (this.config.hasScopes()) {
            request.setScope(this.config.getScopesAsString());
        }
        if (this.config.hasAcrValue()) {
            request.addCustomParameter(ACR_VALUES_PARAM_NAME, this.config.getAcrValue());
        }
        if (userip != null) {
            request.addCustomParameter(REMOTE_IP_PARAM_NAME, userip);
        }
        request.addCustomParameter(STEP_PARAM_NAME, INITIATE_AUTH_STEP_NAME);
        request.addCustomParameter(AUTH_SCHEME_PARAM_NAME, this.authScheme.schemeName());
        this.configureTokenRequestAuthentication(request, username, password);
        return request;
    }

    private final TokenRequest createResendNotificationTokenRequest(String username, String password, String userip) {
        TokenRequest request = new TokenRequest(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
        if (this.config.hasScopes()) {
            request.setScope(this.config.getScopesAsString());
        }
        if (this.config.hasAcrValue()) {
            request.addCustomParameter(ACR_VALUES_PARAM_NAME, this.config.getAcrValue());
        }
        if (this.authContext.getSessionId() != null) {
            request.addCustomParameter("__session_id", this.authContext.getSessionId());
        }
        if (userip != null) {
            request.addCustomParameter(REMOTE_IP_PARAM_NAME, userip);
        }
        request.addCustomParameter(STEP_PARAM_NAME, RESEND_NOTIFICATION_STEP_NAME);
        this.configureTokenRequestAuthentication(request, username, password);
        return request;
    }

    private final TokenRequest createVerifyAuthTokenRequest(String username, String password) {
        TokenRequest request = new TokenRequest(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
        if (this.config.hasScopes()) {
            request.setScope(this.config.getScopesAsString());
        }
        if (this.config.hasAcrValue()) {
            request.addCustomParameter(ACR_VALUES_PARAM_NAME, this.config.getAcrValue());
        }
        if (this.authContext.getSessionId() != null) {
            request.addCustomParameter("__session_id", this.authContext.getSessionId());
        }
        request.addCustomParameter(STEP_PARAM_NAME, VERIFY_AUTH_STEP_NAME);
        this.configureTokenRequestAuthentication(request, username, password);
        return request;
    }

    private final void configureTokenRequestAuthentication(TokenRequest request, String username, String password) {
        request.setAuthenticationMethod(this.config.getAuthenticationMethod());
        request.setUsername(username);
        request.setPassword("");
        if (password != null) {
            request.addCustomParameter(PASSWORD_PARAM_NAME, password);
        } else {
            request.addCustomParameter(PASSWORD_PARAM_NAME, "");
        }
        if (AuthenticationMethod.CLIENT_SECRET_BASIC == this.config.getAuthenticationMethod()) {
            request.setAuthUsername(this.config.getClientId());
            request.setAuthPassword(this.config.getClientSecret());
        }
        if (AuthenticationMethod.PRIVATE_KEY_JWT == this.config.getAuthenticationMethod()) {
            request.setKeyId(this.config.getKeyId());
            request.setCryptoProvider(this.cryptoProvider);
            request.setAlgorithm(this.config.getAlgorithm());
            request.setAudience(this.config.getAudience());
            request.setAuthUsername(this.config.getClientId());
        }
    }

    private boolean verifyJwtSignature(Jwt jwt) {
        try {
            String keyId = jwt.getHeader().getKeyId();
            return this.cryptoProvider.verifySignature(jwt.getSigningInput(), jwt.getEncodedSignature(), keyId, this.serverKeyset, null, jwt.getHeader().getSignatureAlgorithm());
        }
        catch (Exception e) {
            log.debug((Object)"JWT token signature verification failed", (Throwable)e);
            return false;
        }
    }

    private boolean verifyIdTokenSignature(String idToken) {
        try {
            Jwt jwt = Jwt.parse((String)idToken);
            return this.verifyJwtSignature(jwt);
        }
        catch (InvalidJwtException e) {
            log.debug((Object)"Id token validation failed.", (Throwable)e);
            return false;
        }
    }

    private boolean extractSessionIdFromIdToken(String idToken) {
        try {
            Jwt jwt = Jwt.parse((String)idToken);
            if (!this.verifyJwtSignature(jwt)) {
                log.debug((Object)"Jwt signature verification failed during session_id extraction");
                return false;
            }
            if (!jwt.getClaims().hasClaim("__session_id")) {
                log.debug((Object)"No session_id claim found in JWT token");
                return false;
            }
            this.authContext.setSessionId(jwt.getClaims().getClaimAsString("__session_id"));
            return true;
        }
        catch (InvalidJwtException e) {
            log.debug((Object)"IdToken parse failed during sesion_id extraction.", (Throwable)e);
            return false;
        }
    }

    private class AuthenticationContext {
        private String sessionId = "";

        public String getSessionId() {
            return this.sessionId;
        }

        public void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }
    }
}

