/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.util.security;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.KeySpec;
import java.util.concurrent.locks.ReentrantLock;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringEncrypter {
    private static final Logger LOG = LoggerFactory.getLogger(StringEncrypter.class);
    private final ReentrantLock lock = new ReentrantLock();
    public static final String DEFAULT_ENCRYPTION_KEY = "This is a fairly long phrase used to encrypt";
    public static final String DES_ENCRYPTION_SCHEME = "DES";
    public static final String DESEDE_ENCRYPTION_SCHEME = "DESede";
    private static final String UNICODE_FORMAT = "UTF8";
    private Cipher cipher;
    private SecretKeyFactory keyFactory;
    private KeySpec keySpec;
    private Base64 base64 = new Base64();

    public StringEncrypter() {
    }

    public static StringEncrypter defaultInstance() throws EncryptionException {
        return Holder.INSTANCE;
    }

    public static StringEncrypter instance(String encryptionKey) throws EncryptionException {
        return new StringEncrypter(DESEDE_ENCRYPTION_SCHEME, encryptionKey);
    }

    private static String bytes2String(byte[] bytes) throws UnsupportedEncodingException {
        return new String(bytes, "UTF-8");
    }

    public StringEncrypter(String encryptionScheme) throws EncryptionException {
        try {
            this.keyFactory = SecretKeyFactory.getInstance(encryptionScheme);
            this.cipher = Cipher.getInstance(encryptionScheme);
        }
        catch (NoSuchAlgorithmException e) {
            throw new EncryptionException(e);
        }
        catch (NoSuchPaddingException e) {
            throw new EncryptionException(e);
        }
    }

    public StringEncrypter(String encryptionScheme, String encryptionKey) throws EncryptionException {
        if (encryptionKey == null) {
            throw new IllegalArgumentException("encryption key was null");
        }
        if (encryptionKey.trim().length() < 24) {
            throw new IllegalArgumentException("encryption key was less than 24 characters");
        }
        try {
            byte[] keyAsBytes = encryptionKey.getBytes(UNICODE_FORMAT);
            if (encryptionScheme.equalsIgnoreCase(DESEDE_ENCRYPTION_SCHEME)) {
                this.keySpec = new DESedeKeySpec(keyAsBytes);
            } else if (encryptionScheme.equalsIgnoreCase(DES_ENCRYPTION_SCHEME)) {
                this.keySpec = new DESKeySpec(keyAsBytes);
            } else {
                throw new IllegalArgumentException("Encryption scheme not supported: " + encryptionScheme);
            }
            this.keyFactory = SecretKeyFactory.getInstance(encryptionScheme);
            this.cipher = Cipher.getInstance(encryptionScheme);
        }
        catch (InvalidKeyException e) {
            throw new EncryptionException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new EncryptionException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new EncryptionException(e);
        }
        catch (NoSuchPaddingException e) {
            throw new EncryptionException(e);
        }
    }

    private String decrypt(String encryptedString, KeySpec keySpec, boolean silent) throws EncryptionException {
        if (keySpec == null) {
            throw new IllegalArgumentException("keySpec was null or empty");
        }
        if (encryptedString == null || encryptedString.trim().length() <= 0) {
            throw new IllegalArgumentException("encrypted string was null or empty");
        }
        try {
            SecretKey key = this.keyFactory.generateSecret(keySpec);
            this.cipher.init(2, key);
            byte[] cleartext = this.base64.decode(encryptedString.getBytes("UTF-8"));
            byte[] ciphertext = this.cipher.doFinal(cleartext);
            return StringEncrypter.bytes2String(ciphertext);
        }
        catch (Exception e) {
            if (silent) {
                return encryptedString;
            }
            throw new EncryptionException(e);
        }
    }

    public String decrypt(String encryptedString) throws EncryptionException {
        return this.decrypt(encryptedString, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String decrypt(String encryptedString, boolean silent) throws EncryptionException {
        this.lock.lock();
        try {
            String string = this.decrypt(encryptedString, this.keySpec, silent);
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String decrypt(String encryptedString, String encryptionKey) throws EncryptionException {
        return this.decrypt(encryptedString, encryptionKey, false);
    }

    public String decrypt(String encryptedString, String encryptionKey, boolean silent) throws EncryptionException {
        this.lock.lock();
        try {
            KeySpec keySpec;
            byte[] keyAsBytes = encryptionKey.getBytes(UNICODE_FORMAT);
            String encryptionScheme = DESEDE_ENCRYPTION_SCHEME;
            if (encryptionScheme.equalsIgnoreCase(DESEDE_ENCRYPTION_SCHEME)) {
                keySpec = new DESedeKeySpec(keyAsBytes);
            } else if (encryptionScheme.equalsIgnoreCase(DES_ENCRYPTION_SCHEME)) {
                keySpec = new DESKeySpec(keyAsBytes);
            } else {
                throw new IllegalArgumentException("Encryption scheme not supported: " + encryptionScheme);
            }
            String string = this.decrypt(encryptedString, keySpec, silent);
            return string;
        }
        catch (Exception e) {
            throw new EncryptionException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    private String encrypt(String unencryptedString, KeySpec keySpec) throws EncryptionException {
        if (keySpec == null) {
            throw new IllegalArgumentException("keySpec was null or empty");
        }
        if (unencryptedString == null || unencryptedString.trim().length() == 0) {
            throw new IllegalArgumentException("unencrypted string was null or empty");
        }
        try {
            SecretKey key = this.keyFactory.generateSecret(keySpec);
            this.cipher.init(1, key);
            byte[] cleartext = unencryptedString.getBytes(UNICODE_FORMAT);
            byte[] ciphertext = this.cipher.doFinal(cleartext);
            return new String(this.base64.encode(ciphertext), "UTF-8");
        }
        catch (Exception e) {
            throw new EncryptionException(e);
        }
    }

    public String encrypt(String unencryptedString) throws EncryptionException {
        this.lock.lock();
        try {
            String string = this.encrypt(unencryptedString, this.keySpec);
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String encrypt(String unencryptedString, String encryptionKey) throws EncryptionException {
        this.lock.lock();
        try {
            KeySpec keySpec;
            byte[] keyAsBytes = encryptionKey.getBytes(UNICODE_FORMAT);
            String encryptionScheme = DESEDE_ENCRYPTION_SCHEME;
            if (encryptionScheme.equalsIgnoreCase(DESEDE_ENCRYPTION_SCHEME)) {
                keySpec = new DESedeKeySpec(keyAsBytes);
            } else if (encryptionScheme.equalsIgnoreCase(DES_ENCRYPTION_SCHEME)) {
                keySpec = new DESKeySpec(keyAsBytes);
            } else {
                throw new IllegalArgumentException("Encryption scheme not supported: " + encryptionScheme);
            }
            String string = this.encrypt(unencryptedString, keySpec);
            return string;
        }
        catch (Exception e) {
            throw new EncryptionException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public static class EncryptionException
    extends Exception {
        private static final long serialVersionUID = -7220454928814292801L;

        public EncryptionException(Throwable t) {
            super(t);
        }
    }

    private static class Holder {
        static final StringEncrypter INSTANCE = Holder.createInstance();

        private Holder() {
        }

        private static StringEncrypter createInstance() {
            try {
                return new StringEncrypter(StringEncrypter.DESEDE_ENCRYPTION_SCHEME);
            }
            catch (EncryptionException e) {
                LOG.error("Failed to create default StringEncrypter instance", (Throwable)e);
                return null;
            }
        }
    }
}

