/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.gluu.util.io.DownloadWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileDownloader {
    private static Logger LOG = LoggerFactory.getLogger(FileDownloader.class);

    private FileDownloader() {
    }

    public static SimpleDateFormat responseHeaderDateFormat() {
        return new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", Locale.ENGLISH);
    }

    public static void sendError(HttpServletResponse response) {
        FileDownloader.sendError(response, null);
    }

    public static void sendError(HttpServletResponse response, String message) {
        try {
            if (message == null) {
                response.sendError(404);
            } else {
                response.sendError(404, message);
            }
        }
        catch (IOException ex) {
            LOG.error("Error while sending page 404", (Throwable)ex);
        }
    }

    public static int writeOutput(DownloadWrapper downloadWrapper, ContentDisposition contentDisposition, HttpServletResponse response) throws IOException {
        return FileDownloader.writeOutputImpl(downloadWrapper, contentDisposition, response);
    }

    @Deprecated
    public static int writeOutput(DownloadWrapper downloadWrapper, boolean inline, HttpServletResponse response) throws IOException {
        return FileDownloader.writeOutputImpl(downloadWrapper, inline ? ContentDisposition.INLINE : ContentDisposition.ATTACHEMENT, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int writeOutputImpl(DownloadWrapper downloadWrapper, ContentDisposition contentDisposition, HttpServletResponse response) throws IOException {
        LOG.debug("Downloading File: fileName='{}',mimeType='{}', size='{}'", new Object[]{downloadWrapper.getName(), downloadWrapper.getContentType(), downloadWrapper.getContentLength()});
        if (response == null || !downloadWrapper.isReady()) {
            throw new IOException(String.format("Invalid OutputStream or FileDownloadWrapper '%s' specified", downloadWrapper));
        }
        if (contentDisposition != null && ContentDisposition.NONE != contentDisposition) {
            StringBuilder contentDispositionValue = new StringBuilder();
            if (ContentDisposition.INLINE == contentDisposition) {
                contentDispositionValue.append("inline; ");
            } else if (ContentDisposition.ATTACHEMENT == contentDisposition) {
                contentDispositionValue.append("attachment; ");
            }
            contentDispositionValue.append("filename=\"").append(downloadWrapper.getName()).append('\"');
            response.setHeader("Content-Disposition", contentDispositionValue.toString());
        }
        response.setContentLength(downloadWrapper.getContentLength());
        response.setContentType(downloadWrapper.getContentType());
        response.setHeader("Last-Modified", FileDownloader.responseHeaderDateFormat().format(downloadWrapper.getModificationDate()));
        LOG.debug("Writing file to output stream");
        int bytesTransfered = 0;
        ServletOutputStream out = response.getOutputStream();
        try {
            bytesTransfered = IOUtils.copy((InputStream)downloadWrapper.getStream(), (OutputStream)out);
            out.flush();
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
        LOG.debug("Send " + bytesTransfered + " bytes from file");
        return bytesTransfered;
    }

    public static enum ContentDisposition {
        INLINE,
        ATTACHEMENT,
        NONE;

    }
}

