/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.model;

import java.util.HashMap;
import java.util.Map;
import org.gluu.persist.annotation.AttributeEnum;

public enum ProgrammingLanguage implements AttributeEnum
{
    PYTHON("python", "Jython"),
    JAVA_SCRIPT("javascript", "JavaScript");

    private String value;
    private String displayName;
    private static Map<String, ProgrammingLanguage> MAP_BY_VALUES;

    private ProgrammingLanguage(String value, String displayName) {
        this.value = value;
        this.displayName = displayName;
    }

    public String getValue() {
        return this.value;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static ProgrammingLanguage getByValue(String value) {
        return MAP_BY_VALUES.get(value);
    }

    public Enum<? extends AttributeEnum> resolveByValue(String value) {
        return ProgrammingLanguage.getByValue(value);
    }

    public String toString() {
        return this.value;
    }

    static {
        MAP_BY_VALUES = new HashMap<String, ProgrammingLanguage>();
        for (ProgrammingLanguage enumType : ProgrammingLanguage.values()) {
            MAP_BY_VALUES.put(enumType.getValue(), enumType);
        }
    }
}

