/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.client;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang.StringUtils;
import org.gluu.oxauth.client.BaseRequest;

public class OpenIdConnectDiscoveryRequest
extends BaseRequest {
    private String resource;
    private String host;
    private String path;

    public OpenIdConnectDiscoveryRequest(String resource) throws URISyntaxException {
        this.resource = resource;
        if (StringUtils.isBlank((String)resource)) {
            throw new IllegalArgumentException("Resource cannot be null");
        }
        if (resource.startsWith("=") || resource.startsWith("@") || resource.startsWith("!")) {
            throw new UnsupportedOperationException("XRI is not supported");
        }
        if (resource.contains("@")) {
            this.host = resource.substring(resource.indexOf("@") + 1);
        } else {
            if (!resource.contains("://")) {
                resource = "https://" + resource;
            }
            URI uri = new URI(resource);
            this.host = uri.getHost();
            if (uri.getPort() != -1) {
                this.host = this.host + ":" + uri.getPort();
            }
            if (StringUtils.isNotBlank((String)uri.getPath()) && !uri.getPath().equals(uri.getHost()) && !uri.getPath().equals("/")) {
                this.path = uri.getPath();
            }
        }
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public String getQueryString() {
        StringBuilder queryStringBuilder = new StringBuilder();
        try {
            org.gluu.oxauth.model.util.StringUtils.addQueryStringParam((StringBuilder)queryStringBuilder, (String)"resource", (Object)this.resource);
            org.gluu.oxauth.model.util.StringUtils.addQueryStringParam((StringBuilder)queryStringBuilder, (String)"rel", (Object)"http://openid.net/specs/connect/1.0/issuer");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return queryStringBuilder.toString();
    }
}

