/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.client;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.gluu.oxauth.client.ClientAuthnRequest;
import org.gluu.oxauth.model.common.AuthenticationMethod;
import org.gluu.oxauth.model.util.Util;
import org.json.JSONException;

public class DeviceAuthzRequest
extends ClientAuthnRequest {
    private static final Logger LOG = Logger.getLogger(DeviceAuthzRequest.class);
    private String clientId;
    private List<String> scopes;

    public DeviceAuthzRequest(String clientId, List<String> scopes) {
        this.setContentType("application/x-www-form-urlencoded");
        this.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_BASIC);
        this.clientId = clientId;
        this.scopes = scopes;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public String getScopesAsString() {
        return Util.listAsString(this.scopes);
    }

    @Override
    public Map<String, String> getParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        try {
            String scopesAsString = this.getScopesAsString();
            if (StringUtils.isNotBlank((String)this.clientId)) {
                parameters.put("client_id", this.clientId);
            }
            if (StringUtils.isNotBlank((String)scopesAsString)) {
                parameters.put("scope", scopesAsString);
            }
            for (String key : this.getCustomParameters().keySet()) {
                parameters.put(key, this.getCustomParameters().get(key));
            }
        }
        catch (JSONException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return parameters;
    }

    @Override
    public String getQueryString() {
        StringBuilder queryStringBuilder = new StringBuilder();
        try {
            String scopesAsString = this.getScopesAsString();
            if (StringUtils.isNotBlank((String)this.clientId)) {
                queryStringBuilder.append("&").append("client_id").append("=").append(URLEncoder.encode(this.clientId, "UTF-8"));
            }
            if (StringUtils.isNotBlank((String)scopesAsString)) {
                queryStringBuilder.append("&").append("scope").append("=").append(URLEncoder.encode(scopesAsString, "UTF-8"));
            }
            for (String key : this.getCustomParameters().keySet()) {
                queryStringBuilder.append("&");
                queryStringBuilder.append(key).append("=").append(this.getCustomParameters().get(key));
            }
        }
        catch (UnsupportedEncodingException | JSONException e) {
            LOG.error((Object)e.getMessage(), e);
        }
        return queryStringBuilder.toString();
    }
}

