/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.service.cache;

import org.gluu.persist.PersistenceEntryManager;
import org.gluu.service.cache.AbstractCacheProvider;
import org.gluu.service.cache.CacheConfiguration;
import org.gluu.service.cache.CacheProvider;
import org.gluu.service.cache.CacheProviderType;
import org.gluu.service.cache.InMemoryCacheProvider;
import org.gluu.service.cache.MemcachedProvider;
import org.gluu.service.cache.NativePersistenceCacheProvider;
import org.gluu.service.cache.RedisProvider;
import org.gluu.util.StringHelper;
import org.gluu.util.security.StringEncrypter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneCacheProviderFactory {
    private static final Logger LOG = LoggerFactory.getLogger(StandaloneCacheProviderFactory.class);
    private PersistenceEntryManager entryManager;
    private StringEncrypter stringEncrypter;

    public StandaloneCacheProviderFactory(PersistenceEntryManager entryManager, StringEncrypter stringEncrypter) {
        this.entryManager = entryManager;
        this.stringEncrypter = stringEncrypter;
    }

    public CacheProvider<?> getCacheProvider(CacheConfiguration cacheConfiguration) {
        CacheProviderType cacheProviderType = cacheConfiguration.getCacheProviderType();
        if (cacheProviderType == null) {
            LOG.error("Failed to initialize cacheProvider, cacheProviderType is null. Fallback to IN_MEMORY type.");
            cacheProviderType = CacheProviderType.IN_MEMORY;
        }
        AbstractCacheProvider cacheProvider = null;
        switch (cacheProviderType) {
            case IN_MEMORY: {
                InMemoryCacheProvider inMemoryCacheProvider = new InMemoryCacheProvider();
                inMemoryCacheProvider.configure(cacheConfiguration);
                inMemoryCacheProvider.init();
                cacheProvider = inMemoryCacheProvider;
                break;
            }
            case MEMCACHED: {
                MemcachedProvider memcachedProvider = new MemcachedProvider();
                memcachedProvider.configure(cacheConfiguration);
                memcachedProvider.init();
                cacheProvider = memcachedProvider;
                break;
            }
            case REDIS: {
                if (this.stringEncrypter == null) {
                    throw new RuntimeException("Factory is not initialized properly. stringEncrypter is not specified");
                }
                RedisProvider redisProvider = new RedisProvider();
                redisProvider.configure(cacheConfiguration, this.stringEncrypter);
                redisProvider.init();
                cacheProvider = redisProvider;
                break;
            }
            case NATIVE_PERSISTENCE: {
                if (this.entryManager == null) {
                    throw new RuntimeException("Factory is not initialized properly. entryManager is not specified");
                }
                NativePersistenceCacheProvider nativePersistenceCacheProvider = new NativePersistenceCacheProvider();
                nativePersistenceCacheProvider.configure(cacheConfiguration, this.entryManager);
                if (StringHelper.isEmpty((String)cacheConfiguration.getNativePersistenceConfiguration().getBaseDn())) {
                    cacheConfiguration.getNativePersistenceConfiguration().setBaseDn("o=gluu");
                }
                nativePersistenceCacheProvider.init();
                cacheProvider = nativePersistenceCacheProvider;
            }
        }
        if (cacheProvider == null) {
            throw new RuntimeException("Failed to initialize cacheProvider, cacheProviderType is unsupported: " + (Object)((Object)cacheProviderType));
        }
        cacheProvider.create();
        return cacheProvider;
    }
}

