/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.idp.script.service.external;

import java.util.Map;
import org.gluu.model.custom.script.CustomScriptType;
import org.gluu.model.custom.script.conf.CustomScriptConfiguration;
import org.gluu.model.custom.script.type.idp.IdpType;
import org.gluu.service.custom.script.ExternalScriptService;

public class IdpExternalScriptService
extends ExternalScriptService {
    private static final long serialVersionUID = -1316361273036208685L;

    public IdpExternalScriptService() {
        super(CustomScriptType.IDP);
    }

    public boolean executeExternalTranslateAttributesMethod(Object context, CustomScriptConfiguration customScriptConfiguration) {
        try {
            this.log.debug("Executing python 'translateAttributes' method");
            IdpType idpType = (IdpType)customScriptConfiguration.getExternalType();
            Map configurationAttributes = customScriptConfiguration.getConfigurationAttributes();
            return idpType.translateAttributes(context, configurationAttributes);
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(customScriptConfiguration.getCustomScript(), ex);
            return false;
        }
    }

    public boolean executeExternalTranslateAttributesMethod(Object context) {
        boolean result = true;
        for (CustomScriptConfiguration customScriptConfiguration : this.customScriptConfigurations) {
            if (customScriptConfiguration.getExternalType().getApiVersion() <= 1 || (result &= this.executeExternalTranslateAttributesMethod(context, customScriptConfiguration))) continue;
            return result;
        }
        return result;
    }

    public boolean executeExternalUpdateAttributesMethod(Object context, CustomScriptConfiguration customScriptConfiguration) {
        try {
            this.log.debug("Executing python 'updateAttributes' method");
            IdpType idpType = (IdpType)customScriptConfiguration.getExternalType();
            Map configurationAttributes = customScriptConfiguration.getConfigurationAttributes();
            return idpType.updateAttributes(context, configurationAttributes);
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(customScriptConfiguration.getCustomScript(), ex);
            return false;
        }
    }

    public boolean executeExternalUpdateAttributesMethod(Object context) {
        boolean result = true;
        for (CustomScriptConfiguration customScriptConfiguration : this.customScriptConfigurations) {
            if (customScriptConfiguration.getExternalType().getApiVersion() <= 1 || (result &= this.executeExternalUpdateAttributesMethod(context, customScriptConfiguration))) continue;
            return result;
        }
        return result;
    }
}

