/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.client;

import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang.StringUtils;
import org.gluu.oxauth.client.BaseClient;
import org.gluu.oxauth.client.JwkRequest;
import org.gluu.oxauth.client.JwkResponse;
import org.gluu.oxauth.model.crypto.PublicKey;
import org.gluu.oxauth.model.crypto.signature.ECDSAPublicKey;
import org.gluu.oxauth.model.crypto.signature.RSAPublicKey;
import org.gluu.oxauth.model.jwk.JSONWebKeySet;
import org.jboss.resteasy.client.ClientExecutor;
import org.json.JSONObject;

public class JwkClient
extends BaseClient<JwkRequest, JwkResponse> {
    private static final String mediaType = "application/json";

    public JwkClient(String url) {
        super(url);
    }

    @Override
    public String getHttpMethod() {
        return "GET";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JwkResponse exec() {
        if (this.getRequest() == null) {
            this.setRequest(new JwkRequest());
        }
        this.initClientRequest();
        if (((JwkRequest)this.getRequest()).hasCredentials()) {
            String encodedCredentials = ((JwkRequest)this.getRequest()).getEncodedCredentials();
            this.clientRequest.header("Authorization", (Object)("Basic " + encodedCredentials));
        }
        this.clientRequest.accept(mediaType);
        this.clientRequest.setHttpMethod(this.getHttpMethod());
        try {
            JSONObject jsonObj;
            this.clientResponse = this.clientRequest.get(String.class);
            int status = this.clientResponse.getStatus();
            this.setResponse(new JwkResponse(status));
            ((JwkResponse)this.getResponse()).setHeaders((MultivaluedMap<String, Object>)this.clientResponse.getMetadata());
            String entity = (String)this.clientResponse.getEntity(String.class);
            ((JwkResponse)this.getResponse()).setEntity(entity);
            if (StringUtils.isNotBlank((String)entity) && (jsonObj = new JSONObject(entity)).has("keys")) {
                JSONWebKeySet jwks = JSONWebKeySet.fromJSONObject((JSONObject)jsonObj);
                ((JwkResponse)this.getResponse()).setJwks(jwks);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.closeConnection();
        }
        return (JwkResponse)this.getResponse();
    }

    public static RSAPublicKey getRSAPublicKey(String jwkSetUri, String keyId) {
        return JwkClient.getRSAPublicKey(jwkSetUri, keyId, null);
    }

    public static RSAPublicKey getRSAPublicKey(String jwkSetUri, String keyId, ClientExecutor clientExecutor) {
        PublicKey pk;
        RSAPublicKey publicKey = null;
        JwkClient jwkClient = new JwkClient(jwkSetUri);
        jwkClient.setExecutor(clientExecutor);
        JwkResponse jwkResponse = jwkClient.exec();
        if (jwkResponse != null && jwkResponse.getStatus() == 200 && (pk = jwkResponse.getPublicKey(keyId)) instanceof RSAPublicKey) {
            publicKey = (RSAPublicKey)pk;
        }
        return publicKey;
    }

    public static ECDSAPublicKey getECDSAPublicKey(String jwkSetUrl, String keyId) {
        return JwkClient.getECDSAPublicKey(jwkSetUrl, keyId, null);
    }

    public static ECDSAPublicKey getECDSAPublicKey(String jwkSetUrl, String keyId, ClientExecutor clientExecutor) {
        PublicKey pk;
        JwkResponse jwkResponse;
        ECDSAPublicKey publicKey = null;
        JwkClient jwkClient = new JwkClient(jwkSetUrl);
        if (clientExecutor != null) {
            jwkClient.setExecutor(clientExecutor);
        }
        if ((jwkResponse = jwkClient.exec()) != null && jwkResponse.getStatus() == 200 && (pk = jwkResponse.getPublicKey(keyId)) instanceof ECDSAPublicKey) {
            publicKey = (ECDSAPublicKey)pk;
        }
        return publicKey;
    }
}

