/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.client;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.gluu.oxauth.client.BaseResponse;
import org.gluu.oxauth.client.QueryStringDecoder;
import org.gluu.oxauth.model.authorize.AuthorizeErrorResponseType;
import org.gluu.oxauth.model.common.ResponseMode;
import org.gluu.oxauth.model.common.TokenType;
import org.jboss.resteasy.client.ClientResponse;
import org.json.JSONException;
import org.json.JSONObject;

public class AuthorizationResponse
extends BaseResponse {
    private String code;
    private String accessToken;
    private TokenType tokenType;
    private Integer expiresIn;
    private String scope;
    private String idToken;
    private String state;
    private String sessionId;
    private String sid;
    private Map<String, String> customParams;
    private ResponseMode responseMode;
    private AuthorizeErrorResponseType errorType;
    private String errorDescription;
    private String errorUri;

    public AuthorizationResponse(ClientResponse<String> clientResponse) {
        super(clientResponse);
        this.customParams = new HashMap<String, String>();
        if (StringUtils.isNotBlank((String)this.entity)) {
            try {
                JSONObject jsonObj = new JSONObject(this.entity);
                if (jsonObj.has("error")) {
                    this.errorType = AuthorizeErrorResponseType.fromString((String)jsonObj.getString("error"));
                }
                if (jsonObj.has("error_description")) {
                    this.errorDescription = jsonObj.getString("error_description");
                }
                if (jsonObj.has("error_uri")) {
                    this.errorUri = jsonObj.getString("error_uri");
                }
                if (jsonObj.has("state")) {
                    this.state = jsonObj.getString("state");
                }
                if (jsonObj.has("redirect")) {
                    this.location = jsonObj.getString("redirect");
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        this.processLocation();
    }

    public AuthorizationResponse(String location) {
        this.location = location;
        this.customParams = new HashMap<String, String>();
        this.processLocation();
    }

    private void processLocation() {
        try {
            if (StringUtils.isNotBlank((String)this.location)) {
                Map<String, String> params = null;
                int fragmentIndex = this.location.indexOf("#");
                if (fragmentIndex != -1) {
                    this.responseMode = ResponseMode.FRAGMENT;
                    String fragment = this.location.substring(fragmentIndex + 1);
                    params = QueryStringDecoder.decode(fragment);
                } else {
                    int queryStringIndex = this.location.indexOf("?");
                    if (queryStringIndex != -1) {
                        this.responseMode = ResponseMode.QUERY;
                        String queryString = this.location.substring(queryStringIndex + 1);
                        params = QueryStringDecoder.decode(queryString);
                    }
                }
                if (params != null) {
                    if (params.containsKey("code")) {
                        this.code = params.get("code");
                        params.remove("code");
                    }
                    if (params.containsKey("session_id")) {
                        this.sessionId = params.get("session_id");
                        params.remove("session_id");
                    }
                    if (params.containsKey("sid")) {
                        this.sid = params.get("sid");
                        params.remove("sid");
                    }
                    if (params.containsKey("access_token")) {
                        this.accessToken = params.get("access_token");
                        params.remove("access_token");
                    }
                    if (params.containsKey("token_type")) {
                        this.tokenType = TokenType.fromString((String)params.get("token_type"));
                        params.remove("token_type");
                    }
                    if (params.containsKey("expires_in")) {
                        this.expiresIn = Integer.parseInt(params.get("expires_in"));
                        params.remove("expires_in");
                    }
                    if (params.containsKey("scope")) {
                        this.scope = URLDecoder.decode(params.get("scope"), "UTF-8");
                        params.remove("scope");
                    }
                    if (params.containsKey("id_token")) {
                        this.idToken = params.get("id_token");
                        params.remove("id_token");
                    }
                    if (params.containsKey("state")) {
                        this.state = params.get("state");
                        params.remove("state");
                    }
                    if (params.containsKey("error")) {
                        this.errorType = AuthorizeErrorResponseType.fromString((String)params.get("error"));
                        params.remove("error");
                    }
                    if (params.containsKey("error_description")) {
                        this.errorDescription = URLDecoder.decode(params.get("error_description"), "UTF-8");
                        params.remove("error_description");
                    }
                    if (params.containsKey("error_uri")) {
                        this.errorUri = URLDecoder.decode(params.get("error_uri"), "UTF-8");
                        params.remove("error_uri");
                    }
                    for (String key : params.keySet()) {
                        this.getCustomParams().put(key, params.get(key));
                    }
                }
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getSid() {
        return this.sid;
    }

    public void setSid(String sid) {
        this.sid = sid;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String p_sessionId) {
        this.sessionId = p_sessionId;
    }

    public Map<String, String> getCustomParams() {
        return this.customParams;
    }

    public void setCustomParams(Map<String, String> customParams) {
        this.customParams = customParams;
    }

    public ResponseMode getResponseMode() {
        return this.responseMode;
    }

    public void setResponseMode(ResponseMode responseMode) {
        this.responseMode = responseMode;
    }

    public TokenType getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(TokenType tokenType) {
        this.tokenType = tokenType;
    }

    public Integer getExpiresIn() {
        return this.expiresIn;
    }

    public void setExpiresIn(Integer expiresIn) {
        this.expiresIn = expiresIn;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getIdToken() {
        return this.idToken;
    }

    public void setIdToken(String idToken) {
        this.idToken = idToken;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public AuthorizeErrorResponseType getErrorType() {
        return this.errorType;
    }

    public void setErrorType(AuthorizeErrorResponseType errorType) {
        this.errorType = errorType;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    public void setErrorDescription(String errorDescription) {
        this.errorDescription = errorDescription;
    }

    public String getErrorUri() {
        return this.errorUri;
    }

    public void setErrorUri(String errorUri) {
        this.errorUri = errorUri;
    }
}

