/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.idp.storage;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.constraints.NotEmpty;
import org.opensaml.storage.MutableStorageRecord;

public class VersionMutableStorageRecord
extends MutableStorageRecord
implements Serializable,
Externalizable {
    private static final long serialVersionUID = 8516163557055487227L;

    public VersionMutableStorageRecord() {
        super(null, null);
    }

    public VersionMutableStorageRecord(@Nonnull @NotEmpty String value, @Nullable Long expiration, Long version) {
        super(value, expiration);
        super.setVersion(version.longValue());
    }

    public static int expiry(Long exp) {
        return exp == null ? 0 : (int)(exp / 1000L);
    }

    public int getExpiry() {
        return VersionMutableStorageRecord.expiry(this.getExpiration());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.getValue());
        if (this.getExpiration() == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeLong(this.getExpiration());
        }
        out.writeLong(this.getVersion());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.setValue(in.readUTF());
        if (in.readBoolean()) {
            this.setExpiration(in.readLong());
        }
        this.setVersion(in.readLong());
    }
}

