/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.idp.status;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gluu.idp.externalauth.openid.conf.IdpConfigurationFactory;
import org.gluu.persist.PersistenceEntryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="ShibOxAuthHealthCheck", urlPatterns={"/health-check"})
public class HealthCheckServlet
extends HttpServlet {
    private static final long serialVersionUID = -1264851392327422662L;
    private final Logger LOG = LoggerFactory.getLogger(HealthCheckServlet.class);
    private PersistenceEntryManager persistenceEntryManager;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        IdpConfigurationFactory configurationFactory = IdpConfigurationFactory.instance();
        this.persistenceEntryManager = configurationFactory.getPersistenceEntryManager();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        boolean isConnected = this.persistenceEntryManager.getOperationService().isConnected();
        String dbStatus = isConnected ? "online" : "offline";
        String resultResponse = "{\"status\": \"running\", \"db_status\":\"" + dbStatus + "\"}";
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        try (PrintWriter out = response.getWriter();){
            out.print(resultResponse);
            response.setStatus(200);
            out.flush();
        }
        catch (IOException e) {
            this.LOG.error("Error sending health-check response");
            response.resetBuffer();
            response.setStatus(404);
        }
    }
}

