/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.idp.externalauth;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.idp.authn.ExternalAuthentication;
import net.shibboleth.idp.authn.ExternalAuthenticationException;
import org.apache.commons.lang.StringUtils;
import org.gluu.context.J2EContext;
import org.gluu.context.WebContext;
import org.gluu.idp.externalauth.AuthenticatedNameTranslator;
import org.gluu.idp.externalauth.OxAuthToShibTranslator;
import org.gluu.idp.externalauth.TranslateAttributesContext;
import org.gluu.idp.externalauth.openid.client.IdpAuthClient;
import org.gluu.idp.script.service.IdpCustomScriptManager;
import org.gluu.idp.script.service.external.IdpExternalScriptService;
import org.gluu.oxauth.client.auth.principal.OpenIdCredentials;
import org.gluu.oxauth.client.auth.user.UserProfile;
import org.gluu.oxauth.model.exception.InvalidJwtException;
import org.gluu.oxauth.model.jwt.Jwt;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.RequestedAuthnContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

@WebServlet(name="ShibOxAuthAuthServlet", urlPatterns={"/Authn/oxAuth/*"})
public class ShibOxAuthAuthServlet
extends HttpServlet {
    private static final long serialVersionUID = -4864851392327422662L;
    private final Logger LOG = LoggerFactory.getLogger(ShibOxAuthAuthServlet.class);
    private final String OXAUTH_PARAM_ENTITY_ID = "entityId";
    private final String OXAUTH_PARAM_ISSUER_ID = "issuerId";
    private final String OXAUTH_ATTRIBIUTE_SEND_END_SESSION_REQUEST = "sendEndSession";
    private IdpAuthClient authClient;
    private final Set<OxAuthToShibTranslator> translators = new HashSet<OxAuthToShibTranslator>();
    private IdpCustomScriptManager customScriptManager;
    private IdpExternalScriptService externalScriptService;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        ServletContext context = this.getServletContext();
        WebApplicationContext applicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)context);
        this.authClient = (IdpAuthClient)((Object)applicationContext.getBean("idpAuthClient"));
        this.customScriptManager = (IdpCustomScriptManager)((Object)applicationContext.getBean("idpCustomScriptManager"));
        this.customScriptManager.init();
        this.externalScriptService = this.customScriptManager.getIdpExternalScriptService();
        ApplicationContext ac = (ApplicationContext)context.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        this.buildTranslators(ac.getEnvironment());
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        try {
            String requestUrl = request.getRequestURL().toString();
            this.LOG.trace("Get request to: '{}'", (Object)requestUrl);
            boolean logoutEndpoint = requestUrl.endsWith("/logout");
            if (logoutEndpoint) {
                this.processLogoutRequest(request, response);
                return;
            }
            boolean ssoLogoutEndpoint = requestUrl.endsWith("/ssologout");
            if (ssoLogoutEndpoint) {
                this.processSsoLogoutRequest(request, response);
                return;
            }
            J2EContext context = new J2EContext(request, response);
            boolean authorizationResponse = this.authClient.isAuthorizationResponse((WebContext)context);
            Object externalRequest = request;
            if (authorizationResponse) {
                try {
                    final Jwt jwt = Jwt.parse((String)this.authClient.getRequestState((WebContext)context));
                    externalRequest = new HttpServletRequestWrapper(request){

                        public String getParameter(String name) {
                            if (jwt.getClaims().hasClaim(name)) {
                                return jwt.getClaims().getClaimAsString(name);
                            }
                            return super.getParameter(name);
                        }
                    };
                }
                catch (InvalidJwtException ex) {
                    this.LOG.debug("State is not in JWT format", (Throwable)ex);
                }
            }
            String authenticationKey = ExternalAuthentication.startExternalAuthentication((HttpServletRequest)externalRequest);
            boolean force = Boolean.parseBoolean(request.getAttribute("forceAuthn").toString());
            if (!authorizationResponse) {
                this.LOG.debug("Initiating oxAuth login redirect");
                this.startLoginRequest(request, response, force);
                return;
            }
            this.LOG.info("Processing authorization response");
            if (!this.authClient.isValidRequestState((WebContext)context)) {
                this.LOG.error("The state in session and in request are not equals");
                this.startLoginRequest(request, response, force);
                return;
            }
            this.processAuthorizationResponse(request, response, authenticationKey);
        }
        catch (ExternalAuthenticationException ex) {
            this.LOG.warn("Error processing oxAuth authentication request", (Throwable)ex);
            this.loadErrorPage(request, response);
        }
        catch (Exception ex) {
            this.LOG.error("Something unexpected happened", (Throwable)ex);
            request.setAttribute("authnError", (Object)"AuthenticationException");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAuthorizationResponse(HttpServletRequest request, HttpServletResponse response, String authenticationKey) throws ExternalAuthenticationException, IOException {
        try {
            J2EContext context = new J2EContext(request, response);
            OpenIdCredentials openIdCredentials = this.authClient.getCredentials((WebContext)context);
            this.LOG.debug("Client name : '{}'", (Object)openIdCredentials.getClientName());
            UserProfile userProfile = this.authClient.getUserProfile(openIdCredentials, (WebContext)context);
            this.LOG.debug("User profile : {}", (Object)userProfile);
            if (userProfile == null) {
                this.LOG.error("Token validation failed, returning InvalidToken");
                request.setAttribute("authnError", (Object)"InvalidToken");
            } else {
                boolean result = false;
                if (this.externalScriptService.isEnabled()) {
                    TranslateAttributesContext translateAttributesContext = this.buildContext(request, response, userProfile, authenticationKey);
                    result = this.externalScriptService.executeExternalTranslateAttributesMethod(translateAttributesContext);
                }
                if (!result) {
                    this.LOG.trace("Using default translate attributes method");
                    for (OxAuthToShibTranslator translator : this.translators) {
                        translator.doTranslation(request, response, userProfile, authenticationKey);
                    }
                }
            }
        }
        catch (Exception ex) {
            this.LOG.error("Token validation failed, returning InvalidToken", (Throwable)ex);
            request.setAttribute("authnError", (Object)"InvalidToken");
        }
        finally {
            ExternalAuthentication.finishExternalAuthentication((String)authenticationKey, (HttpServletRequest)request, (HttpServletResponse)response);
        }
    }

    protected void startLoginRequest(HttpServletRequest request, HttpServletResponse response, Boolean force) {
        try {
            J2EContext context = new J2EContext(request, response);
            HashMap<String, String> customResponseHeaders = new HashMap<String, String>();
            String convId = request.getParameter("conversation");
            customResponseHeaders.put("conversation", convId);
            HashMap<String, String> customParameters = new HashMap<String, String>();
            String relayingPartyId = request.getAttribute("relyingParty").toString();
            customParameters.put("entityId", relayingPartyId);
            try {
                ProfileRequestContext prc = ExternalAuthentication.getProfileRequestContext((String)convId, (HttpServletRequest)request);
                AuthnRequest authnRequest = (AuthnRequest)prc.getInboundMessageContext().getMessage();
                if (authnRequest != null) {
                    RequestedAuthnContext authnContext = authnRequest.getRequestedAuthnContext();
                    Issuer issuer = authnRequest.getIssuer();
                    if (issuer != null) {
                        customParameters.put("issuerId", issuer.getValue());
                    }
                    if (null != authnContext) {
                        String acrs = authnContext.getAuthnContextClassRefs().stream().map(AuthnContextClassRef::getAuthnContextClassRef).collect(Collectors.joining(" "));
                        customParameters.put("acr_values", acrs);
                    }
                }
            }
            catch (Exception e) {
                this.LOG.error("Unable to process to AuthnContextClassRef", (Throwable)e);
            }
            String loginUrl = this.authClient.getRedirectionUrl((WebContext)context, customResponseHeaders, customParameters, force);
            this.LOG.debug("Generated redirection Url", (Object)loginUrl);
            this.LOG.debug("loginUrl: {}", (Object)loginUrl);
            response.sendRedirect(loginUrl);
        }
        catch (IOException ex) {
            this.LOG.error("Unable to redirect to oxAuth from ShibOxAuth", (Throwable)ex);
        }
    }

    protected void processLogoutRequest(HttpServletRequest request, HttpServletResponse response) {
        try {
            J2EContext context = new J2EContext(request, response);
            String logoutUrl = this.authClient.getLogoutRedirectionUrl((WebContext)context);
            this.LOG.debug("Generated logout redirection Url", (Object)logoutUrl);
            this.LOG.debug("logoutUrl: {}", (Object)logoutUrl);
            response.sendRedirect(logoutUrl);
            this.authClient.clearAuthorized((WebContext)context);
            this.authClient.setAttribute((WebContext)context, "sendEndSession", Boolean.TRUE);
            this.LOG.debug("Client authorization is removed (set null id_token in session)");
        }
        catch (IOException ex) {
            this.LOG.error("Unable to redirect to oxAuth from ShibOxAuth", (Throwable)ex);
        }
    }

    protected void processSsoLogoutRequest(HttpServletRequest request, HttpServletResponse response) {
        try {
            J2EContext context = new J2EContext(request, response);
            Object sendEndSession = this.authClient.getAttribute((WebContext)context, "sendEndSession");
            if (Boolean.TRUE.equals(sendEndSession)) {
                this.authClient.setAttribute((WebContext)context, "sendEndSession", null);
                this.LOG.debug("Client send end_session request. Ignoring OP initiated logout request");
                return;
            }
            String logoutUrl = "/idp/profile/Logout";
            this.LOG.debug("logoutUrl: {}", (Object)"/idp/profile/Logout");
            response.sendRedirect("/idp/profile/Logout");
            this.authClient.clearAuthorized((WebContext)context);
            this.LOG.debug("Client authorization is removed (set null id_token in session)");
        }
        catch (IOException ex) {
            this.LOG.error("Unable to redirect to oxAuth from ShibOxAuth", (Throwable)ex);
        }
    }

    private void buildTranslators(Environment environment) {
        this.translators.add(new AuthenticatedNameTranslator());
        String oxAuthToShibTranslators = StringUtils.defaultString((String)environment.getProperty("shib.oxauth.oxAuthToShibTranslator", ""));
        for (String classname : StringUtils.split((String)oxAuthToShibTranslators, (char)';')) {
            try {
                this.LOG.debug("Loading translator class {}", (Object)classname);
                Class<?> c = Class.forName(classname);
                OxAuthToShibTranslator e = (OxAuthToShibTranslator)c.newInstance();
                if (e instanceof EnvironmentAware) {
                    ((EnvironmentAware)e).setEnvironment(environment);
                }
                this.translators.add(e);
                this.LOG.debug("Added translator class {}", (Object)classname);
            }
            catch (Exception ex) {
                this.LOG.error("Error building oxAuth to Shib translator with name: " + classname, (Throwable)ex);
            }
        }
    }

    private void loadErrorPage(HttpServletRequest request, HttpServletResponse response) {
        RequestDispatcher requestDispatcher = request.getRequestDispatcher("/no-conversation-state.jsp");
        try {
            requestDispatcher.forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception ex) {
            this.LOG.error("Error rendering the empty conversation state (shib-oxauth-authn3) error view.");
            response.resetBuffer();
            response.setStatus(404);
        }
    }

    private TranslateAttributesContext buildContext(HttpServletRequest request, HttpServletResponse response, UserProfile userProfile, String authenticationKey) {
        TranslateAttributesContext translateAttributesContext = new TranslateAttributesContext(request, response, userProfile, authenticationKey);
        return translateAttributesContext;
    }
}

