/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.idp.externalauth;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.authn.principal.IdPAttributePrincipal;
import net.shibboleth.idp.authn.principal.UsernamePrincipal;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.gluu.idp.externalauth.OxAuthToShibTranslator;
import org.gluu.oxauth.client.auth.user.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticatedNameTranslator
implements OxAuthToShibTranslator {
    private final Logger logger = LoggerFactory.getLogger(AuthenticatedNameTranslator.class);

    @Override
    public void doTranslation(HttpServletRequest request, HttpServletResponse response, UserProfile userProfile, String authenticationKey) throws Exception {
        if (userProfile == null || userProfile.getId() == null) {
            this.logger.error("No valid user profile or principal could be found to translate");
            return;
        }
        this.logger.debug("User profile found: '{}'", (Object)userProfile);
        Collection<IdPAttributePrincipal> profileAttributes = this.produceIdpAttributePrincipal(userProfile.getAttributes());
        if (!profileAttributes.isEmpty()) {
            this.logger.debug("Found attributes from oxAuth. Processing...");
            HashSet<Object> principals = new HashSet<Object>();
            principals.addAll(profileAttributes);
            principals.add(new UsernamePrincipal(userProfile.getId()));
            request.setAttribute("subject", (Object)new Subject(false, principals, Collections.emptySet(), Collections.emptySet()));
            this.logger.info("Created an IdP subject instance with principals containing attributes for {} ", (Object)userProfile.getId());
        } else {
            this.logger.debug("No attributes released from oxAuth. Creating an IdP principal for {}", (Object)userProfile.getId());
            request.setAttribute("principal_name", (Object)userProfile.getId());
        }
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public boolean equals(Object that) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)that);
    }

    public Collection<IdPAttributePrincipal> produceIdpAttributePrincipal(Map<String, Object> openidAttributes) {
        HashSet<IdPAttributePrincipal> principals = new HashSet<IdPAttributePrincipal>();
        for (Map.Entry<String, Object> entry : openidAttributes.entrySet()) {
            IdPAttribute attr = new IdPAttribute(entry.getKey());
            ArrayList<StringAttributeValue> attributeValues = new ArrayList<StringAttributeValue>();
            if (entry.getValue() instanceof Collection) {
                for (Object value : (Collection)entry.getValue()) {
                    attributeValues.add(new StringAttributeValue(value.toString()));
                }
            } else {
                attributeValues.add(new StringAttributeValue(entry.getValue().toString()));
            }
            if (!attributeValues.isEmpty()) {
                attr.setValues(attributeValues);
                this.logger.debug("Added attribute {} with values {}", (Object)entry.getKey(), entry.getValue());
                principals.add(new IdPAttributePrincipal(attr));
                continue;
            }
            this.logger.warn("Skipped attribute {} since it contains no values", (Object)entry.getKey());
        }
        return principals;
    }
}

