/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.idp.consent.processor;

import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.gluu.idp.consent.processor.PostProcessAttributesContext;
import org.gluu.idp.externalauth.openid.conf.IdpConfigurationFactory;
import org.gluu.idp.script.service.IdpCustomScriptManager;
import org.gluu.idp.script.service.external.IdpExternalScriptService;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GluuReleaseAttributesPostProcessor
extends AbstractProfileAction {
    private final Logger LOG = LoggerFactory.getLogger(GluuReleaseAttributesPostProcessor.class);
    private IdpConfigurationFactory configurationFactory = IdpConfigurationFactory.instance();
    private IdpCustomScriptManager customScriptManager = new IdpCustomScriptManager(this.configurationFactory, true);
    private IdpExternalScriptService externalScriptService;

    public GluuReleaseAttributesPostProcessor() {
        this.LOG.debug("ReleaseAttributesPostProcessor: create");
        Constraint.isNotNull((Object)((Object)this.configurationFactory), (String)"Configuration factory cannot be null");
        Constraint.isNotNull((Object)((Object)this.customScriptManager), (String)"Custom script manager cannot be null");
        this.init();
    }

    private void init() {
        this.customScriptManager.init();
        this.externalScriptService = this.customScriptManager.getIdpExternalScriptService();
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        this.LOG.info("Executing external IDP script");
        super.doExecute(profileRequestContext);
        PostProcessAttributesContext context = this.buildContext(profileRequestContext);
        AttributeContext attributeContext = context.getAttributeContext();
        for (String attr : attributeContext.getIdPAttributes().keySet()) {
            this.LOG.info("------------------------attr: {}", (Object)attr);
        }
        if (!this.externalScriptService.isEnabled()) {
            this.LOG.info("Using default release attributes post processor");
            return;
        }
        boolean result = this.externalScriptService.executeExternalUpdateAttributesMethod(context);
        this.LOG.debug("Executed script method 'updateAttributes' with result {}", (Object)result);
    }

    private PostProcessAttributesContext buildContext(ProfileRequestContext profileRequestContext) {
        Function attributeContextLookupStrategy = null;
        attributeContextLookupStrategy = new ChildContextLookup(AttributeContext.class).compose((Function)new ChildContextLookup(RelyingPartyContext.class));
        AttributeContext attributeContext = (AttributeContext)attributeContextLookupStrategy.apply(profileRequestContext);
        PostProcessAttributesContext context = new PostProcessAttributesContext();
        context.setAttributeContext(attributeContext);
        context.setAttributeReleaseAction(this);
        return context;
    }
}

