/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.service.custom.script;

import java.util.ArrayList;
import java.util.List;
import javax.enterprise.inject.Vetoed;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.service.PythonService;
import org.gluu.service.custom.script.CustomScriptManager;
import org.gluu.service.custom.script.ExternalScriptService;
import org.gluu.service.custom.script.StandaloneCustomScriptService;
import org.slf4j.LoggerFactory;

@Vetoed
public class StandaloneCustomScriptManager
extends CustomScriptManager {
    private static final long serialVersionUID = -7212146007659551839L;
    private List<ExternalScriptService> externalScriptServices = new ArrayList<ExternalScriptService>();

    public StandaloneCustomScriptManager(PersistenceEntryManager entryManager, String scriptsBaseDn, String pythonModulesDir) {
        PythonService pythonService = new PythonService();
        pythonService.configure();
        pythonService.init();
        pythonService.initPythonInterpreter(pythonModulesDir);
        StandaloneCustomScriptService standaloneCustomScriptService = new StandaloneCustomScriptService();
        standaloneCustomScriptService.configure(entryManager, scriptsBaseDn);
        this.log = LoggerFactory.getLogger(StandaloneCustomScriptManager.class);
        this.supportedCustomScriptTypes = new ArrayList();
        this.pythonService = pythonService;
        this.customScriptService = standaloneCustomScriptService;
    }

    public void init() {
        this.configure();
        this.reloadTimerEvent(null);
    }

    public void destory() {
        super.destroy(null);
    }

    public void reload() {
        this.reloadTimerEvent(null);
    }

    public void registerExternalScriptService(ExternalScriptService externalScriptService) {
        externalScriptService.configure(this);
        this.externalScriptServices.add(externalScriptService);
        this.supportedCustomScriptTypes.add(externalScriptService.getCustomScriptType());
    }

    @Override
    public void updateScriptServices(boolean syncUpdate) {
        for (ExternalScriptService externalScriptService : this.externalScriptServices) {
            externalScriptService.reload(null);
        }
    }
}

