/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.idp.script.service;

import java.util.Timer;
import java.util.TimerTask;
import net.shibboleth.utilities.java.support.primitive.TimerSupport;
import org.gluu.idp.externalauth.ShibOxAuthAuthServlet;
import org.gluu.idp.externalauth.openid.conf.IdpAppConfiguration;
import org.gluu.idp.externalauth.openid.conf.IdpConfigurationFactory;
import org.gluu.idp.script.service.external.IdpExternalScriptService;
import org.gluu.service.custom.script.ExternalScriptService;
import org.gluu.service.custom.script.StandaloneCustomScriptManager;
import org.gluu.util.init.Initializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdpCustomScriptManager
extends Initializable {
    private final Logger LOG = LoggerFactory.getLogger(ShibOxAuthAuthServlet.class);
    private StandaloneCustomScriptManager standaloneCustomScriptManager;
    private IdpExternalScriptService idpExternalScriptService;
    private Timer internalTaskTimer;

    public IdpCustomScriptManager(IdpConfigurationFactory configurationFactory, boolean init) {
        this.standaloneCustomScriptManager = new StandaloneCustomScriptManager(configurationFactory.getPersistenceEntryManager(), ((IdpAppConfiguration)configurationFactory.getAppConfiguration()).getScriptDn(), configurationFactory.getBaseConfiguration().getString("pythonModulesDir"));
        if (init) {
            this.init();
        }
    }

    public IdpExternalScriptService getIdpExternalScriptService() {
        return this.idpExternalScriptService;
    }

    protected void initInternal() {
        this.idpExternalScriptService = new IdpExternalScriptService();
        this.standaloneCustomScriptManager.registerExternalScriptService((ExternalScriptService)this.idpExternalScriptService);
        this.standaloneCustomScriptManager.init();
        this.internalTaskTimer = new Timer(TimerSupport.getTimerName((Object)((Object)this)), true);
        this.internalTaskTimer.schedule(this.getUpdateTask(), 30000L, 30000L);
    }

    public TimerTask getUpdateTask() {
        return new TimerTask(){

            @Override
            public void run() {
                Long now = System.currentTimeMillis();
                IdpCustomScriptManager.this.LOG.debug("Running udate task at {}", (Object)now);
                try {
                    IdpCustomScriptManager.this.standaloneCustomScriptManager.reload();
                }
                catch (Exception e) {
                    IdpCustomScriptManager.this.LOG.error("Error running udate task for {}", (Object)now, (Object)e);
                }
                IdpCustomScriptManager.this.LOG.debug("Finished udate task for {}", (Object)now);
            }
        };
    }
}

