/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.util;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Logger;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.status.StatusLogger;
import org.gluu.oxauth.model.crypto.AbstractCryptoProvider;
import org.gluu.oxauth.model.crypto.OxAuthCryptoProvider;
import org.gluu.oxauth.model.crypto.OxElevenCryptoProvider;
import org.gluu.oxauth.model.crypto.encryption.KeyEncryptionAlgorithm;
import org.gluu.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.gluu.oxauth.model.jwk.Algorithm;
import org.gluu.oxauth.model.jwk.JSONWebKey;
import org.gluu.oxauth.model.jwk.JSONWebKeySet;
import org.gluu.oxauth.model.jwk.KeyType;
import org.gluu.oxauth.model.jwk.Use;
import org.gluu.oxauth.model.util.SecurityProviderUtility;
import org.gluu.oxauth.model.util.StringUtils;
import org.gluu.util.StringHelper;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class KeyGenerator {
    private static final String SIGNING_KEYS = "sig_keys";
    private static final String ENCRYPTION_KEYS = "enc_keys";
    private static final String KEY_STORE_FILE = "keystore";
    private static final String KEY_STORE_PASSWORD = "keypasswd";
    private static final String DN_NAME = "dnname";
    private static final String OXELEVEN_ACCESS_TOKEN = "at";
    private static final String OXELEVEN_GENERATE_KEY_ENDPOINT = "ox11";
    private static final String EXPIRATION = "expiration";
    private static final String EXPIRATION_HOURS = "expiration_hours";
    private static final String HELP = "h";
    private static final Logger log;

    public static void main(String[] args) throws Exception {
        new Cli(args).parse();
    }

    static {
        StatusLogger.getLogger().setLevel(Level.OFF);
        log = Logger.getLogger(KeyGenerator.class);
    }

    public static class Cli {
        private String[] args = null;
        private Options options = new Options();

        public Cli(String[] args) {
            this.args = args;
            Option signingKeysOption = new Option(KeyGenerator.SIGNING_KEYS, true, "Signature keys to generate. (RS256 RS384 RS512 ES256 ES384 ES512 PS256 PS384 PS512).");
            signingKeysOption.setArgs(-2);
            Option encryptionKeysOption = new Option(KeyGenerator.ENCRYPTION_KEYS, true, "Encryption keys to generate. (RSA_OAEP RSA1_5).");
            encryptionKeysOption.setArgs(-2);
            this.options.addOption(signingKeysOption);
            this.options.addOption(encryptionKeysOption);
            this.options.addOption(KeyGenerator.KEY_STORE_FILE, true, "Key Store file.");
            this.options.addOption(KeyGenerator.KEY_STORE_PASSWORD, true, "Key Store password.");
            this.options.addOption(KeyGenerator.DN_NAME, true, "DN of certificate issuer.");
            this.options.addOption(KeyGenerator.OXELEVEN_ACCESS_TOKEN, true, "oxEleven Access Token");
            this.options.addOption(KeyGenerator.OXELEVEN_GENERATE_KEY_ENDPOINT, true, "oxEleven Generate Key Endpoint.");
            this.options.addOption(KeyGenerator.EXPIRATION, true, "Expiration in days.");
            this.options.addOption(KeyGenerator.EXPIRATION_HOURS, true, "Expiration in hours.");
            this.options.addOption(KeyGenerator.HELP, false, "Show help.");
        }

        public void parse() {
            BasicParser parser = new BasicParser();
            CommandLine cmd = null;
            try {
                List<Algorithm> encryptionAlgorithms;
                cmd = parser.parse(this.options, this.args);
                if (cmd.hasOption(KeyGenerator.HELP)) {
                    this.help();
                }
                if (!cmd.hasOption(KeyGenerator.SIGNING_KEYS) && !cmd.hasOption(KeyGenerator.ENCRYPTION_KEYS) || !cmd.hasOption(KeyGenerator.EXPIRATION) && !cmd.hasOption(KeyGenerator.EXPIRATION_HOURS)) {
                    this.help();
                }
                String[] sigAlgorithms = cmd.getOptionValues(KeyGenerator.SIGNING_KEYS);
                String[] encAlgorithms = cmd.getOptionValues(KeyGenerator.ENCRYPTION_KEYS);
                List<Algorithm> signatureAlgorithms = cmd.hasOption(KeyGenerator.SIGNING_KEYS) ? Algorithm.fromString((String[])sigAlgorithms, (Use)Use.SIGNATURE) : new ArrayList();
                List list = encryptionAlgorithms = cmd.hasOption(KeyGenerator.ENCRYPTION_KEYS) ? Algorithm.fromString((String[])encAlgorithms, (Use)Use.ENCRYPTION) : new ArrayList();
                if (signatureAlgorithms.isEmpty() && encryptionAlgorithms.isEmpty()) {
                    this.help();
                }
                int expiration = StringHelper.toInt((String)cmd.getOptionValue(KeyGenerator.EXPIRATION), (int)0);
                int expiration_hours = StringHelper.toInt((String)cmd.getOptionValue(KeyGenerator.EXPIRATION_HOURS), (int)0);
                if (cmd.hasOption(KeyGenerator.OXELEVEN_ACCESS_TOKEN) && cmd.hasOption(KeyGenerator.OXELEVEN_GENERATE_KEY_ENDPOINT)) {
                    String accessToken = cmd.getOptionValue(KeyGenerator.OXELEVEN_ACCESS_TOKEN);
                    String generateKeyEndpoint = cmd.getOptionValue(KeyGenerator.OXELEVEN_GENERATE_KEY_ENDPOINT);
                    try {
                        OxElevenCryptoProvider cryptoProvider = new OxElevenCryptoProvider(generateKeyEndpoint, null, null, null, accessToken);
                        this.generateKeys((AbstractCryptoProvider)cryptoProvider, signatureAlgorithms, encryptionAlgorithms, expiration, expiration_hours);
                    }
                    catch (Exception e) {
                        log.error((Object)"Failed to generate keys", (Throwable)e);
                        this.help();
                    }
                } else if (cmd.hasOption(KeyGenerator.KEY_STORE_FILE) && cmd.hasOption(KeyGenerator.KEY_STORE_PASSWORD) && cmd.hasOption(KeyGenerator.DN_NAME)) {
                    String keystore = cmd.getOptionValue(KeyGenerator.KEY_STORE_FILE);
                    String keypasswd = cmd.getOptionValue(KeyGenerator.KEY_STORE_PASSWORD);
                    String dnName = cmd.getOptionValue(KeyGenerator.DN_NAME);
                    try {
                        SecurityProviderUtility.installBCProvider((boolean)true);
                        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keystore, keypasswd, dnName);
                        this.generateKeys((AbstractCryptoProvider)cryptoProvider, signatureAlgorithms, encryptionAlgorithms, expiration, expiration_hours);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        log.error((Object)"Failed to generate keys", (Throwable)e);
                        this.help();
                    }
                } else {
                    this.help();
                }
            }
            catch (ParseException e) {
                log.error((Object)"Failed to generate keys", (Throwable)e);
                this.help();
            }
        }

        private void generateKeys(AbstractCryptoProvider cryptoProvider, List<Algorithm> signatureAlgorithms, List<Algorithm> encryptionAlgorithms, int expiration, int expiration_hours) throws Exception, JSONException {
            JSONArray x5c;
            JSONWebKey key;
            JSONObject result;
            JSONWebKeySet jwks = new JSONWebKeySet();
            GregorianCalendar calendar = new GregorianCalendar();
            ((Calendar)calendar).add(5, expiration);
            ((Calendar)calendar).add(10, expiration_hours);
            for (Algorithm algorithm : signatureAlgorithms) {
                SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.fromString((String)algorithm.name());
                result = cryptoProvider.generateKey(algorithm, Long.valueOf(calendar.getTimeInMillis()), Use.SIGNATURE);
                key = new JSONWebKey();
                key.setKid(result.getString("kid"));
                key.setUse(Use.SIGNATURE);
                key.setAlg(algorithm);
                key.setKty(KeyType.fromString((String)signatureAlgorithm.getFamily().toString()));
                key.setExp(Long.valueOf(result.optLong("exp")));
                key.setCrv(signatureAlgorithm.getCurve());
                key.setN(result.optString("n"));
                key.setE(result.optString("e"));
                key.setX(result.optString("x"));
                key.setY(result.optString("y"));
                x5c = result.optJSONArray("x5c");
                key.setX5c(StringUtils.toList((JSONArray)x5c));
                jwks.getKeys().add(key);
            }
            for (Algorithm algorithm : encryptionAlgorithms) {
                KeyEncryptionAlgorithm encryptionAlgorithm = KeyEncryptionAlgorithm.fromName((String)algorithm.getParamName());
                result = cryptoProvider.generateKey(algorithm, Long.valueOf(calendar.getTimeInMillis()), Use.ENCRYPTION);
                key = new JSONWebKey();
                key.setKid(result.getString("kid"));
                key.setUse(Use.ENCRYPTION);
                key.setAlg(algorithm);
                key.setKty(KeyType.fromString((String)encryptionAlgorithm.getFamily()));
                key.setExp(Long.valueOf(result.optLong("exp")));
                key.setN(result.optString("n"));
                key.setE(result.optString("e"));
                key.setX(result.optString("x"));
                key.setY(result.optString("y"));
                x5c = result.optJSONArray("x5c");
                key.setX5c(StringUtils.toList((JSONArray)x5c));
                jwks.getKeys().add(key);
            }
            System.out.println(jwks);
        }

        private void help() {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("KeyGenerator -sig_keys alg ... -enc_keys alg ... -expiration n_days [-expiration_hours n_hours] [-ox11 url] [-keystore path -keypasswd secret -dnname dn_name]", this.options);
            System.exit(0);
        }
    }
}

