/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.client;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.gluu.oxauth.client.BaseClient;
import org.gluu.oxauth.client.ClientAuthnEnabler;
import org.gluu.oxauth.client.ClientAuthnRequest;
import org.gluu.oxauth.client.TokenRevocationRequest;
import org.gluu.oxauth.client.TokenRevocationResponse;
import org.gluu.oxauth.model.common.TokenTypeHint;
import org.jboss.resteasy.client.ClientResponse;

public class TokenRevocationClient
extends BaseClient<TokenRevocationRequest, TokenRevocationResponse> {
    private static final Logger LOG = Logger.getLogger(TokenRevocationClient.class);

    public TokenRevocationClient(String url) {
        super(url);
    }

    @Override
    public String getHttpMethod() {
        return "POST";
    }

    public TokenRevocationResponse execTokenRevocation(String clientId, String clientSecret, String token) {
        return this.execTokenRevocation(clientId, clientSecret, token, null);
    }

    public TokenRevocationResponse execTokenRevocation(String clientId, String clientSecret, String token, TokenTypeHint tokenTypeHint) {
        this.setRequest(new TokenRevocationRequest());
        ((TokenRevocationRequest)this.getRequest()).setToken(token);
        ((TokenRevocationRequest)this.getRequest()).setTokenTypeHint(tokenTypeHint);
        ((TokenRevocationRequest)this.getRequest()).setAuthUsername(clientId);
        ((TokenRevocationRequest)this.getRequest()).setAuthPassword(clientSecret);
        return this.exec();
    }

    public TokenRevocationResponse exec() {
        this.initClientRequest();
        new ClientAuthnEnabler(this.clientRequest).exec((ClientAuthnRequest)this.request);
        this.clientRequest.header("Content-Type", (Object)((TokenRevocationRequest)this.request).getContentType());
        this.clientRequest.setHttpMethod(this.getHttpMethod());
        if (StringUtils.isNotBlank((String)((TokenRevocationRequest)this.getRequest()).getToken())) {
            this.clientRequest.formParameter("token", (Object)((TokenRevocationRequest)this.getRequest()).getToken());
        }
        if (((TokenRevocationRequest)this.getRequest()).getTokenTypeHint() != null) {
            this.clientRequest.formParameter("token_type_hint", (Object)((TokenRevocationRequest)this.getRequest()).getTokenTypeHint());
        }
        if (((TokenRevocationRequest)this.request).getAuthUsername() != null && !((TokenRevocationRequest)this.request).getAuthUsername().isEmpty()) {
            this.clientRequest.formParameter("client_id", (Object)((TokenRevocationRequest)this.request).getAuthUsername());
        }
        try {
            this.clientResponse = this.clientRequest.post(String.class);
            TokenRevocationResponse tokenResponse = new TokenRevocationResponse((ClientResponse<String>)this.clientResponse);
            this.setResponse(tokenResponse);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.closeConnection();
        }
        return (TokenRevocationResponse)this.getResponse();
    }
}

