/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.client;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.lang.StringUtils;
import org.gluu.oxauth.client.BaseRequest;

public class EndSessionRequest
extends BaseRequest {
    private String idTokenHint;
    private String postLogoutRedirectUri;
    private String sessionId;
    private String state;

    public EndSessionRequest(String idTokenHint, String postLogoutRedirectUri, String state) {
        this.idTokenHint = idTokenHint;
        this.postLogoutRedirectUri = postLogoutRedirectUri;
        this.state = state;
    }

    public String getIdTokenHint() {
        return this.idTokenHint;
    }

    public void setAccessToken(String idTokenHint) {
        this.idTokenHint = idTokenHint;
    }

    public String getPostLogoutRedirectUri() {
        return this.postLogoutRedirectUri;
    }

    public void setPostLogoutRedirectUri(String postLogoutRedirectUri) {
        this.postLogoutRedirectUri = postLogoutRedirectUri;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String p_sessionId) {
        this.sessionId = p_sessionId;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    @Override
    public String getQueryString() {
        StringBuilder queryStringBuilder = new StringBuilder();
        try {
            if (StringUtils.isNotBlank((String)this.idTokenHint)) {
                queryStringBuilder.append("id_token_hint").append("=").append(this.idTokenHint);
            }
            if (StringUtils.isNotBlank((String)this.postLogoutRedirectUri)) {
                queryStringBuilder.append("&").append("post_logout_redirect_uri").append("=").append(URLEncoder.encode(this.postLogoutRedirectUri, "UTF-8"));
            }
            if (StringUtils.isNotBlank((String)this.state)) {
                queryStringBuilder.append("&").append("state").append("=").append(URLEncoder.encode(this.state, "UTF-8"));
            }
            if (StringUtils.isNotBlank((String)this.sessionId)) {
                queryStringBuilder.append("&").append("session_id").append("=").append(URLEncoder.encode(this.sessionId, "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return queryStringBuilder.toString();
    }
}

