/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.client;

import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang.StringUtils;
import org.gluu.oxauth.client.BaseClient;
import org.gluu.oxauth.client.EndSessionRequest;
import org.gluu.oxauth.client.EndSessionResponse;
import org.gluu.oxauth.client.QueryStringDecoder;
import org.gluu.oxauth.model.session.EndSessionErrorResponseType;
import org.gluu.oxauth.model.util.Util;
import org.json.JSONException;
import org.json.JSONObject;

public class EndSessionClient
extends BaseClient<EndSessionRequest, EndSessionResponse> {
    private static final String mediaType = "text/plain";

    public EndSessionClient(String url) {
        super(url);
    }

    @Override
    public String getHttpMethod() {
        return "GET";
    }

    public EndSessionResponse execEndSession(String idTokenHint, String postLogoutRedirectUri, String state) {
        this.setRequest(new EndSessionRequest(idTokenHint, postLogoutRedirectUri, state));
        return this.exec();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EndSessionResponse exec() {
        block16: {
            this.initClientRequest();
            this.clientRequest.accept(mediaType);
            this.clientRequest.setHttpMethod(this.getHttpMethod());
            if (StringUtils.isNotBlank((String)((EndSessionRequest)this.getRequest()).getIdTokenHint())) {
                this.clientRequest.queryParameter("id_token_hint", (Object)((EndSessionRequest)this.getRequest()).getIdTokenHint());
            }
            if (StringUtils.isNotBlank((String)((EndSessionRequest)this.getRequest()).getPostLogoutRedirectUri())) {
                this.clientRequest.queryParameter("post_logout_redirect_uri", (Object)((EndSessionRequest)this.getRequest()).getPostLogoutRedirectUri());
            }
            if (StringUtils.isNotBlank((String)((EndSessionRequest)this.getRequest()).getState())) {
                this.clientRequest.queryParameter("state", (Object)((EndSessionRequest)this.getRequest()).getState());
            }
            if (StringUtils.isNotBlank((String)((EndSessionRequest)this.getRequest()).getSessionId())) {
                this.clientRequest.queryParameter("session_id", (Object)((EndSessionRequest)this.getRequest()).getSessionId());
            }
            try {
                this.clientResponse = this.clientRequest.get(String.class);
                int status = this.clientResponse.getStatus();
                this.setResponse(new EndSessionResponse(status));
                String entity = (String)this.clientResponse.getEntity(String.class);
                ((EndSessionResponse)this.getResponse()).setEntity(entity);
                ((EndSessionResponse)this.getResponse()).setHeaders((MultivaluedMap<String, Object>)this.clientResponse.getMetadata());
                if (this.clientResponse.getLocationLink() != null) {
                    String queryString;
                    Map<String, String> params;
                    String location = this.clientResponse.getLocationLink().getHref();
                    ((EndSessionResponse)this.getResponse()).setLocation(location);
                    int queryStringIndex = location.indexOf("?");
                    if (queryStringIndex != -1 && (params = QueryStringDecoder.decode(queryString = location.substring(queryStringIndex + 1))).containsKey("state")) {
                        ((EndSessionResponse)this.getResponse()).setState(params.get("state"));
                    }
                }
                if (Util.isNullOrEmpty((String)entity) || entity.contains("<html>")) break block16;
                try {
                    JSONObject jsonObj = new JSONObject(entity);
                    if (jsonObj.has("error")) {
                        ((EndSessionResponse)this.getResponse()).setErrorType(EndSessionErrorResponseType.fromString((String)jsonObj.getString("error")));
                    }
                    if (jsonObj.has("error_description")) {
                        ((EndSessionResponse)this.getResponse()).setErrorDescription(jsonObj.getString("error_description"));
                    }
                    if (jsonObj.has("error_uri")) {
                        ((EndSessionResponse)this.getResponse()).setErrorUri(jsonObj.getString("error_uri"));
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.closeConnection();
            }
        }
        return (EndSessionResponse)this.getResponse();
    }
}

