/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.service.custom.script;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.BeforeDestroyed;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.gluu.model.ScriptLocationType;
import org.gluu.model.SimpleCustomProperty;
import org.gluu.model.SimpleExtendedCustomProperty;
import org.gluu.model.custom.script.CustomScriptType;
import org.gluu.model.custom.script.conf.CustomScriptConfiguration;
import org.gluu.model.custom.script.model.CustomScript;
import org.gluu.model.custom.script.model.ScriptError;
import org.gluu.model.custom.script.type.BaseExternalType;
import org.gluu.service.PythonService;
import org.gluu.service.cdi.async.Asynchronous;
import org.gluu.service.cdi.event.Scheduled;
import org.gluu.service.cdi.event.UpdateScriptEvent;
import org.gluu.service.custom.inject.ReloadScript;
import org.gluu.service.custom.script.AbstractCustomScriptService;
import org.gluu.service.timer.event.TimerEvent;
import org.gluu.service.timer.schedule.TimerSchedule;
import org.gluu.util.StringHelper;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.slf4j.Logger;

@ApplicationScoped
public class CustomScriptManager
implements Serializable {
    private static final long serialVersionUID = -4225890597520443390L;
    public static final String CUSTOM_SCRIPT_MODIFIED_EVENT_TYPE = "customScriptModifiedEvent";
    public static final int DEFAULT_INTERVAL = 30;
    public static final String[] CUSTOM_SCRIPT_CHECK_ATTRIBUTES = new String[]{"dn", "inum", "oxRevision", "oxScriptType", "oxModuleProperty", "oxEnabled"};
    @Inject
    protected Logger log;
    @Inject
    private Event<TimerEvent> timerEvent;
    @Inject
    protected PythonService pythonService;
    @Inject
    protected AbstractCustomScriptService customScriptService;
    @Inject
    @ReloadScript
    private Event<String> event;
    protected List<CustomScriptType> supportedCustomScriptTypes;
    private Map<String, CustomScriptConfiguration> customScriptConfigurations;
    private AtomicBoolean isActive;
    private long lastFinishedTime;
    private Map<CustomScriptType, List<CustomScriptConfiguration>> customScriptConfigurationsByScriptType;

    @Asynchronous
    public void initTimer(List<CustomScriptType> supportedCustomScriptTypes) {
        this.supportedCustomScriptTypes = supportedCustomScriptTypes;
        this.configure();
        int delay = 30;
        int interval = 30;
        this.reload();
        this.timerEvent.fire((Object)new TimerEvent(new TimerSchedule(30, 30), (Object)new UpdateScriptEvent(), new Annotation[]{Scheduled.Literal.INSTANCE}));
    }

    protected void configure() {
        this.isActive = new AtomicBoolean(false);
        this.lastFinishedTime = System.currentTimeMillis();
    }

    public void reloadTimerEvent(@Observes @Scheduled UpdateScriptEvent updateScriptEvent) {
        if (this.isActive.get()) {
            return;
        }
        if (!this.isActive.compareAndSet(false, true)) {
            return;
        }
        try {
            this.reload();
        }
        catch (Throwable ex) {
            this.log.error("Exception happened while reloading custom scripts configuration", ex);
        }
        finally {
            this.isActive.set(false);
            this.lastFinishedTime = System.currentTimeMillis();
            this.log.trace("Last finished time '{}'", (Object)new Date(this.lastFinishedTime));
        }
    }

    public void destroy(@BeforeDestroyed(value=ApplicationScoped.class) ServletContext init) {
        this.log.debug("Destroying custom scripts configurations");
        if (this.customScriptConfigurations == null) {
            return;
        }
        for (Map.Entry<String, CustomScriptConfiguration> customScriptConfigurationEntry : this.customScriptConfigurations.entrySet()) {
            this.destroyCustomScript(customScriptConfigurationEntry.getValue());
        }
    }

    private void reload() {
        boolean modified = this.reloadImpl();
        if (modified) {
            this.updateScriptServices();
        }
    }

    protected void updateScriptServices() {
        this.event.fire((Object)CUSTOM_SCRIPT_MODIFIED_EVENT_TYPE);
    }

    private boolean reloadImpl() {
        List<Object> customScripts = this.supportedCustomScriptTypes.isEmpty() ? new ArrayList() : this.customScriptService.findCustomScripts(this.supportedCustomScriptTypes, CUSTOM_SCRIPT_CHECK_ATTRIBUTES);
        ReloadResult reloadResult = this.reloadCustomScriptConfigurations(this.customScriptConfigurations, customScripts);
        this.customScriptConfigurations = reloadResult.getCustomScriptConfigurations();
        this.customScriptConfigurationsByScriptType = this.groupCustomScriptConfigurationsByScriptType(this.customScriptConfigurations);
        return reloadResult.isModified();
    }

    private ReloadResult reloadCustomScriptConfigurations(Map<String, CustomScriptConfiguration> customScriptConfigurations, List<CustomScript> newCustomScripts) {
        HashMap<Object, Object> newCustomScriptConfigurations;
        boolean modified = false;
        if (customScriptConfigurations == null) {
            newCustomScriptConfigurations = new HashMap();
            modified = true;
        } else {
            newCustomScriptConfigurations = new HashMap<String, CustomScriptConfiguration>(customScriptConfigurations);
        }
        ArrayList<String> newSupportedCustomScriptInums = new ArrayList<String>();
        for (CustomScript newCustomScript : newCustomScripts) {
            String scriptCode;
            boolean hasChanged;
            if (!newCustomScript.isEnabled()) continue;
            if (ScriptLocationType.FILE == newCustomScript.getLocationType()) {
                long fileModifiactionTime = this.getFileModificationTime(newCustomScript.getLocationPath());
                newCustomScript.setRevision(fileModifiactionTime);
            }
            String newSupportedCustomScriptInum = StringHelper.toLowerCase((String)newCustomScript.getInum());
            newSupportedCustomScriptInums.add(newSupportedCustomScriptInum);
            CustomScriptConfiguration prevCustomScriptConfiguration = (CustomScriptConfiguration)newCustomScriptConfigurations.get(newSupportedCustomScriptInum);
            boolean bl = hasChanged = prevCustomScriptConfiguration == null || prevCustomScriptConfiguration.getCustomScript().getRevision() != newCustomScript.getRevision();
            if (!hasChanged && ScriptLocationType.FILE != newCustomScript.getLocationType()) continue;
            if (prevCustomScriptConfiguration != null) {
                this.destroyCustomScript(prevCustomScriptConfiguration);
            }
            CustomScript loadedCustomScript = this.customScriptService.getCustomScriptByDn(newCustomScript.getScriptType().getCustomScriptModel(), newCustomScript.getDn());
            HashMap<String, SimpleCustomProperty> newConfigurationAttributes = new HashMap<String, SimpleCustomProperty>();
            List<SimpleExtendedCustomProperty> simpleCustomProperties = loadedCustomScript.getConfigurationProperties();
            if (simpleCustomProperties == null) {
                simpleCustomProperties = new ArrayList<SimpleExtendedCustomProperty>(0);
            }
            for (SimpleCustomProperty simpleCustomProperty : simpleCustomProperties) {
                newConfigurationAttributes.put(simpleCustomProperty.getValue1(), simpleCustomProperty);
            }
            if (ScriptLocationType.FILE == loadedCustomScript.getLocationType()) {
                String scriptFromFile;
                long fileModifiactionTime = this.getFileModificationTime(loadedCustomScript.getLocationPath());
                loadedCustomScript.setRevision(fileModifiactionTime);
                if (fileModifiactionTime != 0L && StringHelper.isNotEmpty((String)(scriptFromFile = this.loadFromFile(loadedCustomScript.getLocationPath())))) {
                    loadedCustomScript.setScript(scriptFromFile);
                }
            }
            if ((scriptCode = loadedCustomScript.getScript()) != null) {
                scriptCode = scriptCode.replaceAll(".xdi", ".gluu");
                loadedCustomScript.setScript(scriptCode);
            }
            BaseExternalType baseExternalType = this.createExternalType(loadedCustomScript, newConfigurationAttributes);
            CustomScriptConfiguration newCustomScriptConfiguration = new CustomScriptConfiguration(loadedCustomScript, baseExternalType, newConfigurationAttributes);
            newCustomScriptConfigurations.put(newSupportedCustomScriptInum, newCustomScriptConfiguration);
            modified = true;
        }
        Iterator it = newCustomScriptConfigurations.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry externalAuthenticatorConfigurationEntry = it.next();
            String prevSupportedCustomScriptInum = (String)externalAuthenticatorConfigurationEntry.getKey();
            if (newSupportedCustomScriptInums.contains(prevSupportedCustomScriptInum)) continue;
            this.destroyCustomScript((CustomScriptConfiguration)externalAuthenticatorConfigurationEntry.getValue());
            it.remove();
            modified = true;
        }
        return new ReloadResult(newCustomScriptConfigurations, modified);
    }

    private String loadFromFile(String locationPath) {
        try {
            String scriptFromFile = FileUtils.readFileToString((File)new File(locationPath));
            return scriptFromFile;
        }
        catch (IOException ex) {
            this.log.error("Faield to load script from '{}'", (Object)locationPath);
            return null;
        }
    }

    private long getFileModificationTime(String locationPath) {
        File scriptFile = new File(locationPath);
        if (scriptFile.exists()) {
            return scriptFile.lastModified();
        }
        return 0L;
    }

    private boolean destroyCustomScript(CustomScriptConfiguration customScriptConfiguration) {
        String customScriptInum = customScriptConfiguration.getInum();
        boolean result = this.executeCustomScriptDestroy(customScriptConfiguration);
        if (!result) {
            this.log.error("Failed to destroy custom script '{}' correctly", (Object)customScriptInum);
        }
        return result;
    }

    private Map<CustomScriptType, List<CustomScriptConfiguration>> groupCustomScriptConfigurationsByScriptType(Map<String, CustomScriptConfiguration> customScriptConfigurations) {
        HashMap<CustomScriptType, List<CustomScriptConfiguration>> newCustomScriptConfigurationsByScriptType = new HashMap<CustomScriptType, List<CustomScriptConfiguration>>();
        for (CustomScriptType customScriptType : this.supportedCustomScriptTypes) {
            ArrayList customConfigurationsByScriptType = new ArrayList();
            newCustomScriptConfigurationsByScriptType.put(customScriptType, customConfigurationsByScriptType);
        }
        for (CustomScriptConfiguration customScriptConfiguration : customScriptConfigurations.values()) {
            CustomScriptType customScriptType = customScriptConfiguration.getCustomScript().getScriptType();
            List customConfigurationsByScriptType = (List)newCustomScriptConfigurationsByScriptType.get((Object)customScriptType);
            if (customConfigurationsByScriptType == null) continue;
            customConfigurationsByScriptType.add(customScriptConfiguration);
        }
        return newCustomScriptConfigurationsByScriptType;
    }

    private BaseExternalType createExternalType(CustomScript customScript, Map<String, SimpleCustomProperty> configurationAttributes) {
        BaseExternalType externalType;
        String customScriptInum = customScript.getInum();
        try {
            externalType = this.createExternalTypeFromStringWithPythonException(customScript, configurationAttributes);
        }
        catch (Exception ex) {
            this.log.error("Failed to prepare external type '{}'", (Object)ex, (Object)customScriptInum);
            this.saveScriptError(customScript, ex, true);
            return null;
        }
        if (externalType == null) {
            this.log.debug("Using default external type class");
            this.saveScriptError(customScript, new Exception("Using default external type class"), true);
            externalType = customScript.getScriptType().getDefaultImplementation();
        } else {
            this.clearScriptError(customScript);
        }
        return externalType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseExternalType createExternalTypeFromStringWithPythonException(CustomScript customScript, Map<String, SimpleCustomProperty> configurationAttributes) throws Exception {
        String script = customScript.getScript();
        String scriptName = StringHelper.toLowerCase((String)customScript.getName()) + ".py";
        if (script == null) {
            return null;
        }
        CustomScriptType customScriptType = customScript.getScriptType();
        BaseExternalType externalType = null;
        ByteArrayInputStream bis = null;
        try {
            bis = new ByteArrayInputStream(script.getBytes("UTF-8"));
            externalType = this.pythonService.loadPythonScript(bis, scriptName, customScriptType.getPythonClass(), customScriptType.getCustomScriptType(), new PyObject[]{new PyLong(System.currentTimeMillis())});
        }
        catch (UnsupportedEncodingException e) {
            try {
                this.log.error(String.format("%s. Script inum: %s", e.getMessage(), customScript.getInum()), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bis);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)bis);
        }
        IOUtils.closeQuietly((InputStream)bis);
        if (externalType == null) {
            return null;
        }
        boolean initialized = false;
        try {
            if (externalType.getApiVersion() > 10) {
                initialized = externalType.init(customScript, configurationAttributes);
            } else {
                initialized = externalType.init(configurationAttributes);
                this.log.warn(" Update the script's init method to init(self, customScript, configurationAttributes)", (Object)customScript.getName());
            }
        }
        catch (Exception ex) {
            this.log.error("Failed to initialize custom script: '{}'", (Object)ex, (Object)customScript.getName());
        }
        if (initialized) {
            return externalType;
        }
        return null;
    }

    public boolean executeCustomScriptDestroy(CustomScriptConfiguration customScriptConfiguration) {
        try {
            this.log.debug("Executing python 'destroy' custom script method");
            BaseExternalType externalType = customScriptConfiguration.getExternalType();
            Map<String, SimpleCustomProperty> configurationAttributes = customScriptConfiguration.getConfigurationAttributes();
            return externalType.destroy(configurationAttributes);
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(customScriptConfiguration.getCustomScript(), ex);
            return false;
        }
    }

    public void saveScriptError(CustomScript customScript, Exception exception) {
        this.saveScriptError(customScript, exception, false);
    }

    public void saveScriptError(CustomScript customScript, Exception exception, boolean overwrite) {
        try {
            this.saveScriptErrorImpl(customScript, exception, overwrite);
        }
        catch (Exception ex) {
            this.log.error("Failed to store script '{}' error", (Object)customScript.getInum(), (Object)ex);
        }
    }

    protected void saveScriptErrorImpl(CustomScript customScript, Exception exception, boolean overwrite) {
        String customScriptDn = customScript.getDn();
        Class<? extends CustomScript> scriptType = customScript.getScriptType().getCustomScriptModel();
        CustomScript loadedCustomScript = this.customScriptService.getCustomScriptByDn(scriptType, customScriptDn);
        ScriptError currError = loadedCustomScript.getScriptError();
        if (!overwrite && currError != null) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(ExceptionUtils.getStackTrace((Throwable)exception));
        String message = exception.getMessage();
        if (message != null && !StringUtils.isEmpty((String)message)) {
            builder.append("\n==================Further details============================\n");
            builder.append(message);
        }
        loadedCustomScript.setScriptError(new ScriptError(new Date(), builder.toString()));
        this.customScriptService.update(loadedCustomScript);
    }

    public void clearScriptError(CustomScript customScript) {
        try {
            this.clearScriptErrorImpl(customScript);
        }
        catch (Exception ex) {
            this.log.error("Failed to clear script '{}' error", (Object)customScript.getInum(), (Object)ex);
        }
    }

    protected void clearScriptErrorImpl(CustomScript customScript) {
        String customScriptDn = customScript.getDn();
        Class<? extends CustomScript> scriptType = customScript.getScriptType().getCustomScriptModel();
        CustomScript loadedCustomScript = this.customScriptService.getCustomScriptByDn(scriptType, customScriptDn);
        ScriptError currError = loadedCustomScript.getScriptError();
        if (currError == null) {
            return;
        }
        loadedCustomScript.setScriptError(null);
        this.customScriptService.update(loadedCustomScript);
    }

    public CustomScriptConfiguration getCustomScriptConfigurationByInum(String inum) {
        return this.customScriptConfigurations.get(inum);
    }

    public List<CustomScriptConfiguration> getCustomScriptConfigurationsByScriptType(CustomScriptType customScriptType) {
        List<CustomScriptConfiguration> tmpCustomScriptConfigurationsByScriptType = this.customScriptConfigurationsByScriptType.get((Object)customScriptType);
        if (tmpCustomScriptConfigurationsByScriptType == null) {
            tmpCustomScriptConfigurationsByScriptType = new ArrayList<CustomScriptConfiguration>(0);
        }
        return new ArrayList<CustomScriptConfiguration>(tmpCustomScriptConfigurationsByScriptType);
    }

    public List<CustomScriptConfiguration> getCustomScriptConfigurations() {
        return new ArrayList<CustomScriptConfiguration>(this.customScriptConfigurations.values());
    }

    public List<CustomScriptType> getSupportedCustomScriptTypes() {
        return this.supportedCustomScriptTypes;
    }

    public boolean isSupportedType(CustomScriptType customScriptType) {
        return this.supportedCustomScriptTypes.contains((Object)customScriptType);
    }

    private class ReloadResult {
        private Map<String, CustomScriptConfiguration> customScriptConfigurations;
        private boolean modified;

        ReloadResult(Map<String, CustomScriptConfiguration> customScriptConfigurations, boolean modified) {
            this.customScriptConfigurations = customScriptConfigurations;
            this.modified = modified;
        }

        public Map<String, CustomScriptConfiguration> getCustomScriptConfigurations() {
            return this.customScriptConfigurations;
        }

        public boolean isModified() {
            return this.modified;
        }
    }
}

