/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.service.custom.script;

import com.google.common.base.Optional;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.gluu.model.custom.script.CustomScriptType;
import org.gluu.model.custom.script.model.CustomScript;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.search.filter.Filter;
import org.slf4j.Logger;

public abstract class AbstractCustomScriptService
implements Serializable {
    private static final long serialVersionUID = -6187179012715072064L;
    @Inject
    protected Logger log;
    @Inject
    protected PersistenceEntryManager persistenceEntryManager;

    public void add(CustomScript customScript) {
        this.persistenceEntryManager.persist((Object)customScript);
    }

    public void update(CustomScript customScript) {
        this.persistenceEntryManager.merge((Object)customScript);
    }

    public void remove(CustomScript customScript) {
        this.persistenceEntryManager.remove((Object)customScript);
    }

    public CustomScript getCustomScriptByDn(String customScriptDn, String ... returnAttributes) {
        return (CustomScript)((Object)this.persistenceEntryManager.find((Object)customScriptDn, CustomScript.class, returnAttributes));
    }

    public CustomScript getCustomScriptByDn(Class<?> customScriptType, String customScriptDn) {
        return (CustomScript)((Object)this.persistenceEntryManager.find(customScriptType, (Object)customScriptDn));
    }

    public Optional<CustomScript> getCustomScriptByINum(String baseDn, String inum, String ... returnAttributes) {
        ArrayList<Filter> customScriptTypeFilters = new ArrayList<Filter>();
        Filter customScriptTypeFilter = Filter.createEqualityFilter((String)"inum", (Object)inum);
        customScriptTypeFilters.add(customScriptTypeFilter);
        Filter filter = Filter.createORFilter(customScriptTypeFilters);
        List result = this.persistenceEntryManager.findEntries(baseDn, CustomScript.class, filter, returnAttributes);
        if (result.isEmpty()) {
            return Optional.absent();
        }
        return Optional.of(result.get(0));
    }

    public List<CustomScript> findAllCustomScripts(String[] returnAttributes) {
        String baseDn = this.baseDn();
        List result = this.persistenceEntryManager.findEntries(baseDn, CustomScript.class, null, returnAttributes);
        return result;
    }

    public List<CustomScript> findCustomScripts(List<CustomScriptType> customScriptTypes, String ... returnAttributes) {
        String baseDn = this.baseDn();
        if (customScriptTypes == null || customScriptTypes.size() == 0) {
            return this.findAllCustomScripts(returnAttributes);
        }
        ArrayList<Filter> customScriptTypeFilters = new ArrayList<Filter>();
        for (CustomScriptType customScriptType : customScriptTypes) {
            Filter customScriptTypeFilter = Filter.createEqualityFilter((String)"oxScriptType", (Object)customScriptType.getValue());
            customScriptTypeFilters.add(customScriptTypeFilter);
        }
        Filter filter = Filter.createORFilter(customScriptTypeFilters);
        List result = this.persistenceEntryManager.findEntries(baseDn, CustomScript.class, filter, returnAttributes);
        return result;
    }

    public CustomScript getScriptByInum(String inum) {
        return (CustomScript)((Object)this.persistenceEntryManager.find(CustomScript.class, (Object)this.buildDn(inum)));
    }

    public List<CustomScript> findCustomAuthScripts(String pattern, int sizeLimit) {
        String[] targetArray = new String[]{pattern};
        Filter descriptionFilter = Filter.createSubstringFilter((String)"description", null, (String[])targetArray, null);
        Filter scriptTypeFilter = Filter.createEqualityFilter((String)"oxScriptType", (Object)((Object)CustomScriptType.PERSON_AUTHENTICATION));
        Filter displayNameFilter = Filter.createSubstringFilter((String)"displayName", null, (String[])targetArray, null);
        Filter searchFilter = Filter.createORFilter((Filter[])new Filter[]{descriptionFilter, displayNameFilter});
        return this.persistenceEntryManager.findEntries(this.baseDn(), CustomScript.class, Filter.createANDFilter((Filter[])new Filter[]{searchFilter, scriptTypeFilter}), sizeLimit);
    }

    public List<CustomScript> findCustomAuthScripts(int sizeLimit) {
        Filter searchFilter = Filter.createEqualityFilter((String)"oxScriptType", (Object)CustomScriptType.PERSON_AUTHENTICATION.getValue());
        return this.persistenceEntryManager.findEntries(this.baseDn(), CustomScript.class, searchFilter, sizeLimit);
    }

    public List<CustomScript> findOtherCustomScripts(String pattern, int sizeLimit) {
        String[] targetArray = new String[]{pattern};
        Filter descriptionFilter = Filter.createSubstringFilter((String)"description", null, (String[])targetArray, null);
        Filter scriptTypeFilter = Filter.createNOTFilter((Filter)Filter.createEqualityFilter((String)"oxScriptType", (Object)((Object)CustomScriptType.PERSON_AUTHENTICATION)));
        Filter displayNameFilter = Filter.createSubstringFilter((String)"displayName", null, (String[])targetArray, null);
        Filter searchFilter = Filter.createORFilter((Filter[])new Filter[]{descriptionFilter, displayNameFilter});
        return this.persistenceEntryManager.findEntries(this.baseDn(), CustomScript.class, Filter.createANDFilter((Filter[])new Filter[]{searchFilter, scriptTypeFilter}), sizeLimit);
    }

    public List<CustomScript> findScriptByType(CustomScriptType type, int sizeLimit) {
        Filter searchFilter = Filter.createEqualityFilter((String)"oxScriptType", (Object)((Object)type));
        return this.persistenceEntryManager.findEntries(this.baseDn(), CustomScript.class, searchFilter, sizeLimit);
    }

    public List<CustomScript> findScriptByType(CustomScriptType type) {
        Filter searchFilter = Filter.createEqualityFilter((String)"oxScriptType", (Object)((Object)type));
        return this.persistenceEntryManager.findEntries(this.baseDn(), CustomScript.class, searchFilter, null);
    }

    public List<CustomScript> findScriptByPatternAndType(String pattern, CustomScriptType type, int sizeLimit) {
        String[] targetArray = new String[]{pattern};
        Filter descriptionFilter = Filter.createSubstringFilter((String)"description", null, (String[])targetArray, null);
        Filter displayNameFilter = Filter.createSubstringFilter((String)"displayName", null, (String[])targetArray, null);
        Filter searchFilter = Filter.createORFilter((Filter[])new Filter[]{descriptionFilter, displayNameFilter});
        Filter typeFilter = Filter.createEqualityFilter((String)"oxScriptType", (Object)((Object)type));
        return this.persistenceEntryManager.findEntries(this.baseDn(), CustomScript.class, Filter.createANDFilter((Filter[])new Filter[]{searchFilter, typeFilter}), sizeLimit);
    }

    public List<CustomScript> findScriptByPatternAndType(String pattern, CustomScriptType type) {
        String[] targetArray = new String[]{pattern};
        Filter descriptionFilter = Filter.createSubstringFilter((String)"description", null, (String[])targetArray, null);
        Filter displayNameFilter = Filter.createSubstringFilter((String)"displayName", null, (String[])targetArray, null);
        Filter searchFilter = Filter.createORFilter((Filter[])new Filter[]{descriptionFilter, displayNameFilter});
        Filter typeFilter = Filter.createEqualityFilter((String)"oxScriptType", (Object)((Object)type));
        return this.persistenceEntryManager.findEntries(this.baseDn(), CustomScript.class, Filter.createANDFilter((Filter[])new Filter[]{searchFilter, typeFilter}), null);
    }

    public List<CustomScript> findOtherCustomScripts(int sizeLimit) {
        Filter searchFilter = Filter.createNOTFilter((Filter)Filter.createEqualityFilter((String)"oxScriptType", (Object)((Object)CustomScriptType.PERSON_AUTHENTICATION)));
        return this.persistenceEntryManager.findEntries(this.baseDn(), CustomScript.class, searchFilter, sizeLimit);
    }

    public String buildDn(String customScriptId) {
        StringBuilder dn = new StringBuilder();
        dn.append(String.format("inum=%s,", customScriptId));
        dn.append(this.baseDn());
        return dn.toString();
    }

    public abstract String baseDn();
}

