/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.model;

import java.util.HashMap;
import java.util.Map;

public enum AuthenticationMode {
    BASIC("basic", "Basic"),
    OAUTH("oauth", "OAuth"),
    UMA("uma", "UMA");

    private final String value;
    private final String displayName;
    private static final Map<String, AuthenticationMode> MAP_BY_VALUES;

    private AuthenticationMode(String value, String displayName) {
        this.value = value;
        this.displayName = displayName;
    }

    public String getValue() {
        return this.value;
    }

    public static AuthenticationMode getByValue(String value) {
        return MAP_BY_VALUES.get(value);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public AuthenticationMode resolveByValue(String value) {
        return AuthenticationMode.getByValue(value);
    }

    public String toString() {
        return this.value;
    }

    static {
        MAP_BY_VALUES = new HashMap<String, AuthenticationMode>();
        for (AuthenticationMode enumType : AuthenticationMode.values()) {
            MAP_BY_VALUES.put(enumType.getValue(), enumType);
        }
    }
}

