/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.service.cache;

import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Set;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.gluu.service.cache.AbstractRedisProvider;
import org.gluu.service.cache.RedisConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisSentinelPool;

public class RedisSentinelProvider
extends AbstractRedisProvider {
    private static final Logger LOG = LoggerFactory.getLogger(RedisSentinelProvider.class);
    private JedisSentinelPool pool;

    public RedisSentinelProvider(RedisConfiguration redisConfiguration) {
        super(redisConfiguration);
    }

    @Override
    public void create() {
        try {
            LOG.debug("Starting RedisSentinelProvider ... configuration:" + this.getRedisConfiguration());
            JedisPoolConfig poolConfig = this.createPoolConfig();
            String password = this.redisConfiguration.getPassword();
            this.pool = new JedisSentinelPool(this.getRedisConfiguration().getSentinelMasterGroupName(), (Set)Sets.newHashSet((Object[])StringUtils.split((String)this.getRedisConfiguration().getServers().trim(), (String)",")), (GenericObjectPoolConfig)poolConfig, this.redisConfiguration.getConnectionTimeout(), this.redisConfiguration.getSoTimeout(), password, 0);
            this.testConnection();
            LOG.debug("RedisSentinelProvider started.");
        }
        catch (Exception e) {
            LOG.error("Failed to start RedisSentinelProvider.");
            throw new IllegalStateException("Error starting RedisSentinelProvider", e);
        }
    }

    @Override
    public void destroy() {
        LOG.debug("Destroying RedisSentinelProvider");
        try {
            this.pool.close();
        }
        catch (Exception e) {
            LOG.error("Failed to destroy RedisSentinelProvider", (Throwable)e);
            return;
        }
        LOG.debug("Destroyed RedisSentinelProvider");
    }

    public JedisSentinelPool getDelegate() {
        return this.pool;
    }

    @Override
    public boolean hasKey(String key) {
        try (Jedis resource = this.pool.getResource();){
            Boolean hasKey = resource.exists(key);
            boolean bl = Boolean.TRUE.equals(hasKey);
            return bl;
        }
    }

    @Override
    public Object get(String key) {
        try (Jedis resource = this.pool.getResource();){
            byte[] value = resource.get(key.getBytes());
            Object deserialized = null;
            if (value != null && value.length > 0) {
                deserialized = SerializationUtils.deserialize((byte[])value);
            }
            Object object = deserialized;
            return object;
        }
    }

    @Override
    public void put(int expirationInSeconds, String key, Object object) {
        try (Jedis resource = this.pool.getResource();){
            String status = resource.setex(key.getBytes(), expirationInSeconds, SerializationUtils.serialize((Serializable)((Serializable)object)));
            LOG.trace("put - key: " + key + ", status: " + status);
        }
    }

    @Override
    public void put(String key, Object object) {
        try (Jedis resource = this.pool.getResource();){
            String status = resource.set(key.getBytes(), SerializationUtils.serialize((Serializable)((Serializable)object)));
            LOG.trace("put - key: " + key + ", status: " + status);
        }
    }

    @Override
    public void remove(String key) {
        try (Jedis resource = this.pool.getResource();){
            Long entriesRemoved = resource.del(key.getBytes());
            LOG.trace("remove - key: " + key + ", entriesRemoved: " + entriesRemoved);
        }
    }

    @Override
    public void clear() {
        try (Jedis resource = this.pool.getResource();){
            resource.flushAll();
            LOG.trace("clear");
        }
    }
}

