/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.client.conf;

import java.io.File;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.StringUtils;
import org.gluu.oxauth.client.conf.AppConfiguration;
import org.gluu.oxauth.client.conf.LdapAppConfiguration;
import org.gluu.site.ldap.LDAPConnectionProvider;
import org.gluu.site.ldap.OperationsFacade;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.gluu.site.ldap.persistence.exception.LdapMappingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xdi.util.StringHelper;
import org.xdi.util.exception.ConfigurationException;
import org.xdi.util.properties.FileConfiguration;
import org.xdi.util.security.PropertiesDecrypter;

public abstract class Configuration<C extends AppConfiguration, L extends LdapAppConfiguration> {
    private final Logger logger = LoggerFactory.getLogger(Configuration.class);
    public static final String BASE_DIR = System.getProperty("gluu.base") != null ? System.getProperty("gluu.base") : (System.getProperty("catalina.base") != null && System.getProperty("catalina.base.ignore") == null ? System.getProperty("catalina.base") : (System.getProperty("catalina.home") != null ? System.getProperty("catalina.home") : (System.getProperty("jboss.home.dir") != null ? System.getProperty("jboss.home.dir") : null)));
    public static final String DIR = BASE_DIR + File.separator + "conf" + File.separator;
    public static final String LDAP_DEFAULT_PROPERTIES_FILE = DIR + "ox-ldap.properties";
    private static final String SALT_FILE_NAME = "salt";
    private String confDir;
    private String saltFilePath;
    private FileConfiguration ldapConfiguration;
    private C appConfiguration;
    private String cryptoConfigurationSalt;
    private LdapEntryManager ldapEntryManager;
    private long ldapFileLastModifiedTime;
    private AtomicBoolean isActive = new AtomicBoolean(true);

    protected Configuration() {
        try {
            this.create();
        }
        finally {
            this.isActive.set(false);
        }
    }

    private void create() {
        this.ldapConfiguration = this.loadLdapConfiguration();
        this.confDir = this.confDir();
        this.saltFilePath = this.confDir + SALT_FILE_NAME;
        this.cryptoConfigurationSalt = this.loadCryptoConfigurationSalt();
        this.ldapEntryManager = this.createLdapEntryManager();
        if (!this.createFromLdap()) {
            this.logger.error("Failed to load configuration from Ldap. Please fix it!!!.");
            throw new ConfigurationException("Failed to load configuration from Ldap.");
        }
        this.logger.info("Configuration loaded successfully.");
    }

    public void destroy() {
        if (this.ldapEntryManager != null) {
            this.destroyLdapEntryManager(this.ldapEntryManager);
        }
    }

    private FileConfiguration loadLdapConfiguration() {
        String ldapConfigurationFileName = this.getLdapConfigurationFileName();
        FileConfiguration fileConfiguration = this.loadLdapConfiguration(ldapConfigurationFileName, false);
        if (fileConfiguration == null) {
            ldapConfigurationFileName = this.getDefaultLdapConfigurationFileName();
            fileConfiguration = this.loadLdapConfiguration(ldapConfigurationFileName, true);
        }
        return fileConfiguration;
    }

    public FileConfiguration loadLdapConfiguration(String ldapConfigurationFileName, boolean mandatory) {
        try {
            if (StringHelper.isEmpty((String)ldapConfigurationFileName)) {
                if (mandatory) {
                    throw new ConfigurationException("Failed to load Ldap configuration file!");
                }
                return null;
            }
            String ldapConfigurationFilePath = DIR + ldapConfigurationFileName;
            FileConfiguration ldapConfiguration = new FileConfiguration(ldapConfigurationFilePath);
            if (ldapConfiguration.isLoaded()) {
                File ldapFile = new File(ldapConfigurationFilePath);
                if (ldapFile.exists()) {
                    this.ldapFileLastModifiedTime = ldapFile.lastModified();
                }
                return ldapConfiguration;
            }
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            throw new ConfigurationException("Failed to load Ldap configuration from " + ldapConfigurationFileName, (Throwable)ex);
        }
        if (mandatory) {
            throw new ConfigurationException("Failed to load Ldap configuration from " + ldapConfigurationFileName);
        }
        return null;
    }

    private String loadCryptoConfigurationSalt() {
        try {
            FileConfiguration cryptoConfiguration = new FileConfiguration(this.saltFilePath);
            return cryptoConfiguration.getString("encodeSalt");
        }
        catch (Exception ex) {
            this.logger.error("Failed to load configuration from {}", (Object)this.saltFilePath, (Object)ex);
            throw new ConfigurationException("Failed to load configuration from " + this.saltFilePath, (Throwable)ex);
        }
    }

    private String confDir() {
        String confDir = this.getLdapConfiguration().getString("confDir");
        if (StringUtils.isNotBlank((String)confDir)) {
            return confDir;
        }
        return DIR;
    }

    private boolean createFromLdap() {
        this.logger.info("Loading configuration from Ldap...");
        try {
            L ldapConf = this.loadConfigurationFromLdap(new String[0]);
            if (ldapConf != null) {
                this.appConfiguration = ((LdapAppConfiguration)ldapConf).getApplication();
                return true;
            }
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
        }
        return false;
    }

    private L loadConfigurationFromLdap(String ... returnAttributes) {
        try {
            String dn = this.getLdapConfiguration().getString(this.getApplicationConfigurationPropertyName());
            LdapAppConfiguration ldapConf = (LdapAppConfiguration)this.ldapEntryManager.find(this.getAppConfigurationType(), (Object)dn, returnAttributes);
            return (L)ldapConf;
        }
        catch (LdapMappingException ex) {
            this.logger.error(ex.getMessage());
            return null;
        }
    }

    private LdapEntryManager createLdapEntryManager() {
        Properties connectionProperties = this.ldapConfiguration.getProperties();
        Properties decryptedConnectionProperties = PropertiesDecrypter.decryptProperties((Properties)connectionProperties, (String)this.cryptoConfigurationSalt);
        LDAPConnectionProvider connectionProvider = new LDAPConnectionProvider(decryptedConnectionProperties);
        LdapEntryManager ldapEntryManager = new LdapEntryManager(new OperationsFacade(connectionProvider, null));
        this.logger.debug("Created LdapEntryManager: {}", (Object)ldapEntryManager);
        return ldapEntryManager;
    }

    private void destroyLdapEntryManager(LdapEntryManager ldapEntryManager) {
        boolean result = ldapEntryManager.destroy();
        if (result) {
            this.logger.debug("Destoyed LdapEntryManager: {}", (Object)ldapEntryManager);
        } else {
            this.logger.error("Failed to destoy LdapEntryManager: {}", (Object)ldapEntryManager);
        }
    }

    public FileConfiguration getLdapConfiguration() {
        return this.ldapConfiguration;
    }

    public String getCryptoConfigurationSalt() {
        return this.cryptoConfigurationSalt;
    }

    protected String getDefaultLdapConfigurationFileName() {
        return "ox-ldap.properties";
    }

    public C getAppConfiguration() {
        return this.appConfiguration;
    }

    protected abstract String getLdapConfigurationFileName();

    protected abstract Class<L> getAppConfigurationType();

    protected abstract String getApplicationConfigurationPropertyName();
}

