/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.util.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;

public final class FileHelper {
    private FileHelper() {
    }

    public static File createTempDirectory() throws IOException {
        File temp = File.createTempFile("temp", Long.toString(System.nanoTime()));
        if (!temp.delete()) {
            throw new IOException("Could not delete temp file: " + temp.getAbsolutePath());
        }
        if (!temp.mkdir()) {
            throw new IOException("Could not create temp directory: " + temp.getAbsolutePath());
        }
        return temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File src, File dst) throws IOException {
        FileChannel inChannel = null;
        AbstractInterruptibleChannel outChannel = null;
        try {
            inChannel = new FileInputStream(src).getChannel();
            outChannel = new FileOutputStream(dst).getChannel();
            int maxCount = 67076096;
            long size = inChannel.size();
            for (long position = 0L; position < size; position += inChannel.transferTo(position, maxCount, (WritableByteChannel)((Object)outChannel))) {
            }
        }
        finally {
            if (inChannel != null) {
                inChannel.close();
            }
            if (outChannel != null) {
                outChannel.close();
            }
        }
    }
}

